/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl.adapter;

import android.os.RemoteException;
import anet.channel.a.a;
import anet.channel.util.ALog;
import anetwork.channel.aidl.ParcelableInputStream;
import anetwork.channel.entity.RequestConfig;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ParcelableInputStreamImpl
extends ParcelableInputStream.Stub {
    private static final String TAG = "anet.ParcelableInputStreamImpl";
    private static final a EOS = a.a(0);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private LinkedList<a> byteList = new LinkedList();
    private int index;
    private int offset;
    private int contentLength;
    private int receivedLength = 0;
    private int rto = 10000;
    private String url = "";
    private String seqNo = "";
    final ReentrantLock lock = new ReentrantLock();
    final Condition newDataArrive = this.lock.newCondition();

    public void write(a a2) {
        if (this.isClosed.get()) {
            return;
        }
        this.lock.lock();
        try {
            this.byteList.add(a2);
            this.receivedLength += a2.c();
            this.newDataArrive.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void writeEnd() {
        this.write(EOS);
        if (ALog.isPrintLog(1)) {
            ALog.d(TAG, "set EOS flag to stream", this.seqNo, new Object[0]);
        }
        if (this.contentLength != 0 && this.contentLength != this.receivedLength) {
            ALog.e(TAG, "data length no match!", this.seqNo, "ContentLength", this.contentLength, "Received", this.receivedLength, "url", this.url);
        }
    }

    private void recycleCurrentItem() {
        this.lock.lock();
        try {
            a a2 = this.byteList.set(this.index, EOS);
            a2.d();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int available() throws RemoteException {
        if (this.isClosed.get()) {
            throw new RuntimeException("Stream is closed");
        }
        int n2 = 0;
        this.lock.lock();
        try {
            if (this.index == this.byteList.size()) {
                int n3 = 0;
                return n3;
            }
            ListIterator<a> listIterator = this.byteList.listIterator(this.index);
            while (listIterator.hasNext()) {
                n2 += listIterator.next().c();
            }
        }
        finally {
            this.lock.unlock();
        }
        return n2 -= this.offset;
    }

    @Override
    public void close() throws RemoteException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.lock.lock();
            try {
                for (a a2 : this.byteList) {
                    if (a2 == EOS) continue;
                    a2.d();
                }
                this.byteList.clear();
                this.byteList = null;
                this.index = -1;
                this.offset = -1;
                this.contentLength = 0;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public int readByte() throws RemoteException {
        if (this.isClosed.get()) {
            throw new RuntimeException("Stream is closed");
        }
        int n2 = 0;
        this.lock.lock();
        try {
            while (true) {
                if (this.index == this.byteList.size() && !this.newDataArrive.await(this.rto, TimeUnit.MILLISECONDS)) {
                    this.close();
                    throw new RuntimeException("await timeout.");
                }
                a a2 = this.byteList.get(this.index);
                if (a2 == EOS) {
                    n2 = -1;
                    break;
                }
                if (this.offset < a2.c() - 1) {
                    ++this.offset;
                    n2 = a2.a()[this.offset];
                    break;
                }
                this.recycleCurrentItem();
                ++this.index;
                this.offset = 0;
            }
        }
        catch (InterruptedException interruptedException) {
            this.close();
            throw new RuntimeException("await interrupt");
        }
        finally {
            this.lock.unlock();
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws RemoteException {
        if (this.isClosed.get()) {
            throw new RuntimeException("Stream is closed");
        }
        int n2 = 0;
        this.lock.lock();
        try {
            while (n2 < byArray.length) {
                int n3;
                if (this.index == this.byteList.size() && !this.newDataArrive.await(this.rto, TimeUnit.MILLISECONDS)) {
                    this.close();
                    throw new RuntimeException("await timeout.");
                }
                a a2 = this.byteList.get(this.index);
                if (a2 == EOS) {
                    break;
                }
                int n4 = a2.c() - this.offset;
                if (n4 <= (n3 = byArray.length - n2)) {
                    System.arraycopy(a2.a(), this.offset, byArray, n2, n4);
                    n2 += n4;
                    this.recycleCurrentItem();
                    ++this.index;
                    this.offset = 0;
                    continue;
                }
                System.arraycopy(a2.a(), this.offset, byArray, n2, n3);
                this.offset += n3;
                n2 += n3;
            }
        }
        catch (InterruptedException interruptedException) {
            this.close();
            throw new RuntimeException("await interrupt");
        }
        finally {
            this.lock.unlock();
        }
        return n2 > 0 ? n2 : -1;
    }

    @Override
    public long skip(int n2) throws RemoteException {
        int n3 = 0;
        this.lock.lock();
        try {
            while (n3 < n2) {
                if (this.index == this.byteList.size()) {
                    break;
                }
                a a2 = this.byteList.get(this.index);
                if (a2 == EOS) {
                    break;
                }
                int n4 = a2.c();
                if (n4 - this.offset < n2 - n3) {
                    n3 += n4 - this.offset;
                    this.recycleCurrentItem();
                    ++this.index;
                    this.offset = 0;
                    break;
                }
                n3 = n2;
                this.offset += n2 - n3;
            }
        }
        finally {
            this.lock.unlock();
        }
        return n3;
    }

    @Override
    public int length() throws RemoteException {
        return this.contentLength;
    }

    public void init(RequestConfig requestConfig, int n2) {
        this.contentLength = n2;
        this.seqNo = requestConfig.getSeqNo();
        this.url = requestConfig.getUrlString();
        this.rto = requestConfig.getReadTimeout();
    }
}

