/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl.adapter;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.statist.ExceptionStatistic;
import anet.channel.util.ALog;
import anetwork.channel.Network;
import anetwork.channel.NetworkListener;
import anetwork.channel.Request;
import anetwork.channel.Response;
import anetwork.channel.aidl.Connection;
import anetwork.channel.aidl.DefaultFinishEvent;
import anetwork.channel.aidl.IRemoteNetworkGetter;
import anetwork.channel.aidl.NetworkResponse;
import anetwork.channel.aidl.ParcelableFuture;
import anetwork.channel.aidl.ParcelableRequest;
import anetwork.channel.aidl.RemoteNetwork;
import anetwork.channel.aidl.adapter.ConnectionDelegate;
import anetwork.channel.aidl.adapter.ErrorParcelableFuture;
import anetwork.channel.aidl.adapter.FutureResponse;
import anetwork.channel.aidl.adapter.ParcelableNetworkListenerWrapper;
import anetwork.channel.aidl.adapter.RemoteGetterHelper;
import anetwork.channel.config.NetworkConfigCenter;
import anetwork.channel.http.HttpNetworkDelegate;
import java.util.concurrent.Future;

public class NetworkProxy
implements Network {
    protected static String TAG = "ANet.NetworkProxy";
    private RemoteNetwork mDelegate = null;
    private int mType = 0;
    private Context mContext;
    protected static final int HTTP = 0;
    protected static final int DEGRADE = 1;

    public NetworkProxy(Context context, int n2) {
        this.mContext = context;
        this.mType = n2;
    }

    @Override
    public Connection getConnection(Request request, Object object) {
        this.initDelegateInstance(true);
        ParcelableRequest parcelableRequest = new ParcelableRequest(request);
        if (parcelableRequest.getURL() == null) {
            return new ConnectionDelegate(-102);
        }
        try {
            return this.mDelegate.getConnection(parcelableRequest);
        }
        catch (Throwable throwable) {
            this.reportRemoteError(throwable, "[getConnection]call getConnection method failed.");
            return new ConnectionDelegate(-103);
        }
    }

    @Override
    public Response syncSend(Request request, Object object) {
        this.initDelegateInstance(true);
        ParcelableRequest parcelableRequest = new ParcelableRequest(request);
        if (parcelableRequest.getURL() == null) {
            return new NetworkResponse(-102);
        }
        try {
            return this.mDelegate.syncSend(parcelableRequest);
        }
        catch (Throwable throwable) {
            this.reportRemoteError(throwable, "[syncSend]call syncSend method failed.");
            return new NetworkResponse(-103);
        }
    }

    private void initDelegateInstance(boolean bl) {
        if (this.mDelegate != null) {
            return;
        }
        if (NetworkConfigCenter.isRemoteNetworkServiceEnable()) {
            RemoteGetterHelper.initRemoteGetterAndWait(this.mContext, bl);
            this.mDelegate = this.tryGetRemoteNetworkInstance(this.mType);
        }
        if (this.mDelegate == null) {
            if (ALog.isPrintLog(2)) {
                ALog.i(TAG, "[getLocalNetworkInstance]", null, new Object[0]);
            }
            this.mDelegate = new HttpNetworkDelegate(this.mContext);
        }
    }

    @Override
    public Future<Response> asyncSend(Request request, Object object, Handler handler, NetworkListener networkListener) {
        this.initDelegateInstance(Looper.myLooper() != Looper.getMainLooper());
        FutureResponse futureResponse = new FutureResponse();
        ParcelableRequest parcelableRequest = new ParcelableRequest(request);
        ParcelableNetworkListenerWrapper parcelableNetworkListenerWrapper = null;
        if (networkListener != null || handler != null) {
            parcelableNetworkListenerWrapper = new ParcelableNetworkListenerWrapper(networkListener, handler, object);
        }
        ParcelableFuture parcelableFuture = this.redirectAsyncCall(this.mDelegate, parcelableRequest, parcelableNetworkListenerWrapper);
        futureResponse.setFuture(parcelableFuture);
        return futureResponse;
    }

    private synchronized RemoteNetwork tryGetRemoteNetworkInstance(int n2) {
        if (ALog.isPrintLog(2)) {
            ALog.i(TAG, "[tryGetRemoteNetworkInstance] type=" + n2, null, new Object[0]);
        }
        RemoteNetwork remoteNetwork = null;
        IRemoteNetworkGetter iRemoteNetworkGetter = RemoteGetterHelper.getRemoteGetter();
        if (iRemoteNetworkGetter != null) {
            try {
                remoteNetwork = iRemoteNetworkGetter.get(n2);
            }
            catch (Throwable throwable) {
                this.reportRemoteError(throwable, "[tryGetRemoteNetworkInstance]get RemoteNetwork Delegate failed.");
            }
        }
        return remoteNetwork;
    }

    private ParcelableFuture redirectAsyncCall(RemoteNetwork remoteNetwork, ParcelableRequest parcelableRequest, ParcelableNetworkListenerWrapper parcelableNetworkListenerWrapper) {
        if (remoteNetwork == null) {
            return null;
        }
        ParcelableFuture parcelableFuture = null;
        if (parcelableRequest.getURL() == null) {
            parcelableFuture = this.handleErrorCallBack(parcelableNetworkListenerWrapper, -102);
        } else {
            try {
                parcelableFuture = remoteNetwork.asyncSend(parcelableRequest, parcelableNetworkListenerWrapper);
            }
            catch (Throwable throwable) {
                parcelableFuture = this.handleErrorCallBack(parcelableNetworkListenerWrapper, -103);
                String string = "[redirectAsyncCall]call asyncSend exception.";
                this.reportRemoteError(throwable, string);
            }
        }
        return parcelableFuture;
    }

    private ParcelableFuture handleErrorCallBack(ParcelableNetworkListenerWrapper parcelableNetworkListenerWrapper, int n2) {
        if (parcelableNetworkListenerWrapper != null) {
            try {
                parcelableNetworkListenerWrapper.onFinished(new DefaultFinishEvent(n2));
            }
            catch (RemoteException remoteException) {
                ALog.w(TAG, "[handleErrorCallBack]call listenerWrapper.onFinished exception.", null, remoteException, new Object[0]);
            }
        }
        return new ErrorParcelableFuture(n2);
    }

    private void reportRemoteError(Throwable throwable, String string) {
        ALog.e(TAG, null, string, throwable, new Object[0]);
        ExceptionStatistic exceptionStatistic = new ExceptionStatistic(-103, null, "rt");
        exceptionStatistic.exceptionStack = throwable.toString();
        AppMonitor.getInstance().commitStat(exceptionStatistic);
    }
}

