/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl;

import android.os.Parcel;
import android.os.Parcelable;
import anet.channel.util.ALog;
import anet.channel.util.ErrorConstant;
import anetwork.channel.Response;
import anetwork.channel.statist.StatisticData;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class NetworkResponse
implements Parcelable,
Response {
    private static final String TAG = "ANet.NetworkResponse";
    int statusCode;
    private String desc;
    byte[] bytedata;
    private Map<String, List<String>> connHeadFields;
    private Throwable error;
    private StatisticData statisticData;
    public static final Parcelable.Creator<NetworkResponse> CREATOR = new Parcelable.Creator<NetworkResponse>(){

        public NetworkResponse createFromParcel(Parcel parcel) {
            return NetworkResponse.readFromParcel(parcel);
        }

        public NetworkResponse[] newArray(int n2) {
            return new NetworkResponse[n2];
        }
    };

    public void setStatusCode(int n2) {
        this.statusCode = n2;
        this.desc = ErrorConstant.getErrMsg(n2);
    }

    @Override
    public byte[] getBytedata() {
        return this.bytedata;
    }

    public void setBytedata(byte[] byArray) {
        this.bytedata = byArray;
    }

    public void setConnHeadFields(Map<String, List<String>> map) {
        this.connHeadFields = map;
    }

    @Override
    public Map<String, List<String>> getConnHeadFields() {
        return this.connHeadFields;
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public boolean isHttpSuccess() {
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NetworkResponse [");
        stringBuilder.append("statusCode=").append(this.statusCode);
        stringBuilder.append(", desc=").append(this.desc);
        stringBuilder.append(", connHeadFields=").append(this.connHeadFields);
        stringBuilder.append(", bytedata=").append(this.bytedata != null ? new String(this.bytedata) : "");
        stringBuilder.append(", error=").append(this.error);
        stringBuilder.append(", statisticData=").append(this.statisticData).append("]");
        return stringBuilder.toString();
    }

    public NetworkResponse() {
    }

    public NetworkResponse(int n2) {
        this(n2, null, null);
    }

    public NetworkResponse(int n2, byte[] byArray, Map<String, List<String>> map) {
        this.statusCode = n2;
        this.desc = ErrorConstant.getErrMsg(n2);
        this.bytedata = byArray;
        this.connHeadFields = map;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable throwable) {
        this.error = throwable;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.statusCode);
        parcel.writeString(this.desc);
        int n3 = 0;
        if (this.bytedata != null) {
            n3 = this.bytedata.length;
        }
        parcel.writeInt(n3);
        if (n3 > 0) {
            parcel.writeByteArray(this.bytedata);
        }
        parcel.writeMap(this.connHeadFields);
        if (this.statisticData != null) {
            parcel.writeSerializable((Serializable)this.statisticData);
        }
    }

    public static NetworkResponse readFromParcel(Parcel parcel) {
        NetworkResponse networkResponse = new NetworkResponse();
        try {
            networkResponse.statusCode = parcel.readInt();
            networkResponse.desc = parcel.readString();
            int n2 = parcel.readInt();
            if (n2 > 0) {
                networkResponse.bytedata = new byte[n2];
                parcel.readByteArray(networkResponse.bytedata);
            }
            networkResponse.connHeadFields = parcel.readHashMap(NetworkResponse.class.getClassLoader());
            try {
                networkResponse.statisticData = (StatisticData)parcel.readSerializable();
            }
            catch (Throwable throwable) {
                ALog.i(TAG, "[readFromParcel] source.readSerializable() error", null, new Object[0]);
            }
        }
        catch (Exception exception) {
            ALog.w(TAG, "[readFromParcel]", null, exception, new Object[0]);
        }
        return networkResponse;
    }

    public void setStatisticData(StatisticData statisticData) {
        this.statisticData = statisticData;
    }

    @Override
    public StatisticData getStatisticData() {
        return this.statisticData;
    }
}

