/*
 * Decompiled with CFR 0.152.
 */
package anet.channel;

import android.text.TextUtils;
import anet.channel.AccsSessionManager;
import anet.channel.entity.ENV;
import anet.channel.heartbeat.HeartbeatManager;
import anet.channel.heartbeat.IHeartbeatFactory;
import anet.channel.security.ISecurity;
import anet.channel.security.c;
import anet.channel.strategy.a;
import anet.channel.strategy.dispatch.HttpDispatcher;
import anet.channel.util.ALog;
import anet.channel.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class Config {
    private static final String TAG = "awcn.Config";
    private static Map<String, Config> configMap = new HashMap<String, Config>();
    public static final Config DEFAULT_CONFIG = new Builder().setTag("[default]").setAppkey("[default]").setEnv(ENV.ONLINE).setAccsSessionAutoRecreate(false).setAccsSessionCallback(AccsSessionManager.DISABLE_AUTO_CONNTION).setHeartbeatFactory(null).build();
    private String tag;
    private String appkey;
    private ENV env = ENV.ONLINE;
    private ISecurity iSecurity;
    private String accsHost;
    private int accsPublicKey = -1;
    private AccsSessionManager.Callback accsSessionCb = null;
    private boolean unitEnable = true;
    private boolean accsSessionAutoCreate = true;
    private IHeartbeatFactory heartbeatFactory;

    protected Config() {
    }

    public static Config getConfigByTag(String string) {
        Map<String, Config> map = configMap;
        synchronized (map) {
            return configMap.get(string);
        }
    }

    public static Config getConfig(String string, ENV eNV) {
        Map<String, Config> map = configMap;
        synchronized (map) {
            for (Config config : configMap.values()) {
                if (config.env != eNV || !config.appkey.equals(string)) continue;
                return config;
            }
        }
        return null;
    }

    public String getTag() {
        return this.tag;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public ENV getEnv() {
        return this.env;
    }

    public ISecurity getSecurity() {
        return this.iSecurity;
    }

    public String getAccsHost() {
        return this.accsHost;
    }

    public int getAccsPublicKey() {
        return this.accsPublicKey;
    }

    public AccsSessionManager.Callback getAccsSessionCb() {
        return this.accsSessionCb;
    }

    public boolean isUnitEnable() {
        return this.unitEnable;
    }

    public boolean isAccsSessionAutoCreate() {
        return this.accsSessionAutoCreate;
    }

    public IHeartbeatFactory getHeartbeatFactory() {
        return this.heartbeatFactory;
    }

    public String toString() {
        return this.tag;
    }

    public static class Builder {
        private String tag;
        private String appkey;
        private ENV env = ENV.ONLINE;
        private String authCode;
        private String appSecret;
        private String accsHost;
        private int accsPublicKey = -1;
        private AccsSessionManager.Callback accsSessionCb;
        private boolean unitEnable = true;
        private boolean accsSessionAutoCreate = true;
        private IHeartbeatFactory heartbeatFactory = HeartbeatManager.getHeartbeatFactory();

        public Builder setTag(String string) {
            this.tag = string;
            return this;
        }

        public Builder setAppkey(String string) {
            this.appkey = string;
            return this;
        }

        public Builder setEnv(ENV eNV) {
            this.env = eNV;
            return this;
        }

        public Builder setAuthCode(String string) {
            this.authCode = string;
            return this;
        }

        public Builder setAppSecret(String string) {
            this.appSecret = string;
            return this;
        }

        public Builder setAccsHost(String string) {
            this.accsHost = string;
            HttpDispatcher.getInstance().addHosts(Arrays.asList(string));
            return this;
        }

        public Builder setAccsPublicKey(int n2) {
            this.accsPublicKey = n2;
            return this;
        }

        public Builder setAccsSessionCallback(AccsSessionManager.Callback callback) {
            this.accsSessionCb = callback == null ? AccsSessionManager.DISABLE_AUTO_CONNTION : callback;
            return this;
        }

        public Builder setUnitEnable(boolean bl) {
            this.unitEnable = bl;
            return this;
        }

        public Builder setAccsSessionAutoRecreate(boolean bl) {
            this.accsSessionAutoCreate = bl;
            return this;
        }

        public Builder setHeartbeatFactory(IHeartbeatFactory iHeartbeatFactory) {
            this.heartbeatFactory = iHeartbeatFactory;
            return this;
        }

        public Config build() {
            Object object2;
            if (TextUtils.isEmpty((CharSequence)this.appkey)) {
                throw new RuntimeException("appkey can not be null or empty!");
            }
            for (Object object2 : configMap.values()) {
                if (((Config)object2).env != this.env || !((Config)object2).appkey.equals(this.appkey)) continue;
                ALog.w(Config.TAG, "duplicated config exist!", null, new Object[]{"appkey", this.appkey, "env", this.env});
                if (!TextUtils.isEmpty((CharSequence)this.tag)) {
                    Map map = configMap;
                    synchronized (map) {
                        configMap.put(this.tag, object2);
                    }
                }
                return object2;
            }
            Config config = new Config();
            config.appkey = this.appkey;
            config.env = this.env;
            config.accsSessionCb = this.accsSessionCb;
            config.accsPublicKey = this.accsPublicKey;
            config.unitEnable = this.unitEnable;
            config.accsSessionAutoCreate = this.accsSessionAutoCreate;
            config.heartbeatFactory = this.heartbeatFactory;
            if (TextUtils.isEmpty((CharSequence)this.tag)) {
                config.tag = StringUtils.concatString(this.appkey, "$", this.env.toString());
            } else {
                config.tag = this.tag;
            }
            if (!TextUtils.isEmpty((CharSequence)this.appSecret)) {
                config.iSecurity = c.a().createNonSecurity(this.appSecret);
            } else {
                config.iSecurity = c.a().createSecurity(this.authCode);
            }
            if (TextUtils.isEmpty((CharSequence)this.accsHost)) {
                config.accsHost = a.a(this.env);
            } else {
                config.accsHost = this.accsHost;
            }
            object2 = configMap;
            synchronized (object2) {
                configMap.put(config.tag, config);
            }
            return config;
        }
    }
}

