/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.api.utils;

import cn.jiguang.api.JResponse;
import cn.jiguang.api.utils.ByteBufferUtils;
import cn.jiguang.e.d;
import cn.jiguang.g.l;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class ProtocolUtil {
    public static byte[] getBytesConsumed(ByteBuffer byteBuffer) {
        try {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            return byArray;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            d.g("ProtocolUtil", "[getBytesConsumed] - ByteBuffer error.");
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        try {
            byte[] byArray = new byte[byteBuffer.remaining()];
            ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
            byteBuffer2.flip();
            byteBuffer.get(byArray);
            return byArray;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            d.g("ProtocolUtil", "[getBytes] - ByteBuffer error.");
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] tlv2ToByteArray(String string) {
        if (string == null || "".equals(string)) {
            return new byte[]{0, 0};
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (byArray == null) {
            return new byte[]{0, 0};
        }
        short s2 = (short)byArray.length;
        byte[] byArray2 = new byte[s2 + 2];
        System.arraycopy(ProtocolUtil.short2ByteArray(s2), 0, byArray2, 0, 2);
        System.arraycopy(byArray, 0, byArray2, 2, s2);
        return byArray2;
    }

    public static byte[] fixedStringToBytes(String object, int n2) {
        if (object == null || "".equals(object)) {
            return new byte[]{0, 0, 0, 0};
        }
        byte[] byArray = null;
        try {
            byArray = ((String)object).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (byArray == null) {
            return new byte[]{0, 0, 0, 0};
        }
        object = ProtocolUtil.getDefaultByte(n2);
        n2 = byArray.length > n2 ? n2 : byArray.length;
        System.arraycopy(byArray, 0, object, 0, n2);
        return object;
    }

    public static void fillIntData(byte[] byArray, int n2, int n3) {
        System.arraycopy(ProtocolUtil.int2ByteArray(n2), 0, byArray, n3, 4);
    }

    public static void fillStringData(byte[] byArray, String object, int n2) {
        byte[] byArray2 = ((String)object).getBytes();
        object = byArray2;
        System.arraycopy(byArray2, 0, byArray, n2, ((Object)object).length);
    }

    public static void main(String[] object) {
        object = "ab";
        object = ProtocolUtil.fixedStringToBytes("ab", 4);
        d.c("ProtocolUtil", l.a((byte[])object));
    }

    public static byte[] getDefaultByte(int n2) {
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[0] = 0;
        }
        return byArray;
    }

    public static String getTlv2(ByteBuffer byteBuffer, JResponse jResponse) {
        short s2 = ByteBufferUtils.getShort(byteBuffer, jResponse);
        if (s2 < 0) {
            d.g("ProtocolUtil", "[getTlv2] - ByteBuffer error.");
            return null;
        }
        byte[] byArray = new byte[s2];
        ByteBufferUtils.get(byteBuffer, byArray, jResponse);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String getTlv2(ByteBuffer byteBuffer) {
        try {
            short s2 = byteBuffer.getShort();
            byte[] byArray = new byte[s2];
            byteBuffer.get(byArray);
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Exception exception) {}
        return null;
    }

    public static String getString(ByteBuffer byteBuffer, int n2) {
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] short2ByteArray(short s2) {
        return new byte[]{(byte)(s2 >>> 8), (byte)s2};
    }

    public static byte[] int2ByteArray(int n2) {
        return new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
    }

    public static byte[] long2ByteArray(long l2) {
        return new byte[]{(byte)(l2 >>> 56), (byte)(l2 >>> 48), (byte)(l2 >>> 40), (byte)(l2 >>> 32), (byte)(l2 >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)l2};
    }
}

