/*
 * Decompiled with CFR 0.152.
 */
package com.peng.one.push.jpush;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import cn.jpush.android.api.JPushInterface;
import com.peng.one.push.OneRepeater;
import com.peng.one.push.core.IPushClient;
import com.peng.one.push.log.OneLog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class JPushClient
implements IPushClient {
    private Context context;
    private HashSet<String> tagSet = new HashSet();
    private Handler handler = new Handler();
    private Runnable setTagRunnable = new Runnable(){

        @Override
        public void run() {
            JPushInterface.addTags((Context)JPushClient.this.context, (int)2023, (Set)((Set)JPushClient.this.tagSet.clone()));
            JPushClient.this.tagSet.clear();
        }
    };

    public void initContext(Context context) {
        this.context = context.getApplicationContext();
        JPushInterface.setDebugMode((boolean)OneLog.isDebug());
        JPushInterface.init((Context)context);
    }

    public void register() {
        String token;
        if (JPushInterface.isPushStopped((Context)this.context)) {
            JPushInterface.resumePush((Context)this.context);
        }
        if (!TextUtils.isEmpty((CharSequence)(token = JPushInterface.getRegistrationID((Context)this.context)))) {
            OneRepeater.transmitCommandResult((Context)this.context, (int)2021, (int)200, (String)token, null, null);
        }
    }

    public void unRegister() {
        JPushInterface.stopPush((Context)this.context);
    }

    public void bindAlias(String alias) {
        JPushInterface.setAlias((Context)this.context, (int)2025, (String)alias);
    }

    public void unBindAlias(String alias) {
        JPushInterface.deleteAlias((Context)this.context, (int)2026);
    }

    public void addTag(String tag) {
        this.handler.removeCallbacks(this.setTagRunnable);
        this.tagSet.add(tag);
        this.handler.postDelayed(this.setTagRunnable, 300L);
    }

    public void deleteTag(String tag) {
        JPushInterface.deleteTags((Context)this.context, (int)2024, Collections.singleton(tag));
    }
}

