/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.pushagent;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.huawei.android.pushagent.c.a;
import com.huawei.android.pushagent.c.a.a.e;
import com.huawei.android.pushagent.c.a.f;
import com.huawei.android.pushagent.c.a.h;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class PushReceiver
extends BroadcastReceiver {
    public void onEvent(Context context, Event event, Bundle bundle) {
    }

    public void onToken(Context context, String string, Bundle bundle) {
        this.onToken(context, string);
    }

    public boolean onPushMsg(Context context, byte[] byArray, Bundle bundle) {
        String string = "";
        if (null != bundle) {
            string = bundle.getString("deviceToken");
        }
        this.onPushMsg(context, byArray, string);
        return true;
    }

    public void onPushMsg(Context context, byte[] byArray, String string) {
    }

    public void onPushState(Context context, boolean bl) {
    }

    public void onToken(Context context, String string) {
    }

    public static void getPushState(Context context) {
        com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "enter PushEntity:getPushState() pkgName" + context.getPackageName());
        String string = a.r(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (a.o(context)) {
                com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "votedPackage is null, getPushState from frameworkPush");
                string = "android";
            } else {
                com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "votedPackage is null and not exist frameworkPush, can not getPushState");
                return;
            }
        }
        Intent intent = new Intent("com.huawei.android.push.intent.GET_PUSH_STATE");
        intent.putExtra("pkg_name", context.getPackageName());
        intent.setPackage(string);
        intent.setFlags(32);
        context.sendBroadcast(intent, null);
    }

    public static final void getToken(Context context) {
        com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "enter PushEntity:getToken() pkgName" + context.getPackageName());
        Intent intent = new Intent("com.huawei.android.push.intent.REGISTER");
        intent.putExtra("pkg_name", context.getPackageName());
        int n2 = PushReceiver.a();
        if (-999 != n2) {
            intent.putExtra("userid", String.valueOf(n2));
        }
        intent.setFlags(32);
        if (a.o(context)) {
            intent.setPackage("android");
            com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "send register broadcast to frameworkPush");
        }
        context.sendBroadcast(intent);
        h h2 = new h(context, "push_client_self_info");
        h2.a("hasRequestToken", true);
    }

    public final void onReceive(Context context, Intent intent) {
        try {
            com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "enter PushMsgReceiver:onReceive(Intent:" + intent.getAction() + " pkgName:" + context.getPackageName() + ")");
            String string = intent.getAction();
            if ("com.huawei.android.push.intent.REGISTRATION".equals(string) && intent.hasExtra("device_token")) {
                this.a(context, intent);
            } else if ("com.huawei.android.push.intent.RECEIVE".equals(string) && intent.hasExtra("msg_data")) {
                this.b(context, intent);
            } else if ("com.huawei.android.push.intent.CLICK".equals(string) && intent.hasExtra("click")) {
                this.c(context, intent);
            } else if ("com.huawei.android.push.intent.CLICK".equals(string) && intent.hasExtra("clickBtn")) {
                this.d(context, intent);
            } else if ("com.huawei.intent.action.PUSH_STATE".equals(string)) {
                this.e(context, intent);
            } else if ("com.huawei.android.push.plugin.RESPONSE".equals(string)) {
                this.f(context, intent);
            } else {
                com.huawei.android.pushagent.c.a.e.b("PushLogAC2705", "message can't be recognised:" + intent.toUri(0));
            }
        }
        catch (Exception exception) {
            com.huawei.android.pushagent.c.a.e.c("PushLogAC2705", "call onReceive(intent:" + intent + ") cause:" + exception.toString(), exception);
        }
    }

    protected void a(Context context, Intent intent) throws UnsupportedEncodingException {
        String string = new String(intent.getByteArrayExtra("device_token"), "UTF-8");
        com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "get a deviceToken:" + e.a(string));
        if (TextUtils.isEmpty((CharSequence)string)) {
            com.huawei.android.pushagent.c.a.e.c("PushLogAC2705", "get a deviceToken, but it is null");
            return;
        }
        h h2 = new h(context, "push_client_self_info");
        boolean bl = h2.a("hasRequestToken");
        String string2 = f.a(context, "push_client_self_info", "token_info");
        com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "my oldtoken is :" + e.a(string2));
        if (bl || !string.equals(string2)) {
            com.huawei.android.pushagent.c.a.e.b("PushLogAC2705", "push client begin to receive the token");
            new HandlePushTokenThread(context, string).start();
            Bundle bundle = new Bundle();
            bundle.putString("deviceToken", string);
            bundle.putByteArray("pushMsg", null);
            bundle.putInt("receiveType", ReceiveType.ReceiveType_Token.ordinal());
            if (null != intent.getExtras()) {
                bundle.putAll(intent.getExtras());
            }
            new EventThread(context, bundle).start();
        } else {
            com.huawei.android.pushagent.c.a.e.c("PushLogAC2705", "get a deviceToken, but do not requested token, and new token is equals old token");
        }
    }

    private void b(Context context, Intent intent) throws UnsupportedEncodingException {
        this.g(context, intent);
        h h2 = new h(context, "push_switch");
        boolean bl = h2.a("normal_msg_enable");
        com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "closePush_Normal:" + bl);
        if (bl) {
            com.huawei.android.pushagent.c.a.e.b("PushLogAC2705", "close switch is true, message not dispatch");
            return;
        }
        byte[] byArray = intent.getByteArrayExtra("msg_data");
        String string = new String(intent.getByteArrayExtra("device_token"), "UTF-8");
        com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "PushReceiver receive a message success");
        Bundle bundle = new Bundle();
        bundle.putString("deviceToken", string);
        bundle.putByteArray("pushMsg", byArray);
        bundle.putInt("receiveType", ReceiveType.ReceiveType_Msg.ordinal());
        new EventThread(context, bundle).start();
    }

    private void c(Context context, Intent intent) {
        String string = intent.getStringExtra("click");
        Bundle bundle = new Bundle();
        bundle.putString("pushMsg", string);
        bundle.putInt("receiveType", ReceiveType.ReceiveType_NotifyClick.ordinal());
        new EventThread(context, bundle).start();
    }

    private void d(Context context, Intent intent) {
        String string = intent.getStringExtra("clickBtn");
        int n2 = intent.getIntExtra("notifyId", 0);
        Bundle bundle = new Bundle();
        bundle.putString("pushMsg", string);
        bundle.putInt("pushNotifyId", n2);
        bundle.putInt("receiveType", ReceiveType.ReceiveType_ClickBtn.ordinal());
        new EventThread(context, bundle).start();
    }

    private void e(Context context, Intent intent) {
        boolean bl = intent.getBooleanExtra("push_state", false);
        Bundle bundle = new Bundle();
        bundle.putBoolean("pushState", bl);
        bundle.putInt("receiveType", ReceiveType.ReceiveType_PushState.ordinal());
        new EventThread(context, bundle).start();
    }

    private void f(Context context, Intent intent) {
        int n2 = intent.getIntExtra("reportType", -1);
        boolean bl = intent.getBooleanExtra("isReportSuccess", false);
        Bundle bundle = intent.getBundleExtra("reportExtra");
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("isReportSuccess", bl);
        bundle2.putInt("reportType", n2);
        bundle2.putBundle("reportExtra", bundle);
        bundle2.putInt("receiveType", ReceiveType.ReceiveType_PluginRsp.ordinal());
        new EventThread(context, bundle2).start();
    }

    private static int a() {
        int n2 = -999;
        try {
            Class<?> clazz = Class.forName("android.os.UserHandle");
            Method method = clazz.getDeclaredMethod("myUserId", new Class[0]);
            n2 = (Integer)method.invoke(clazz, new Object[0]);
            com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "getUserId:" + n2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", " getUserId wrong");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", " getUserId wrong");
        }
        catch (IllegalAccessException illegalAccessException) {
            com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", " getUserId wrong");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", " getUserId wrong");
        }
        catch (InvocationTargetException invocationTargetException) {
            com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", " getUserId wrong");
        }
        return n2;
    }

    private void g(Context context, Intent intent) {
        if (null == context || null == intent) {
            return;
        }
        String string = intent.getStringExtra("msgIdStr");
        if (!TextUtils.isEmpty((CharSequence)string) && a.o(context)) {
            Intent intent2 = new Intent("com.huawei.android.push.intent.MSG_RESPONSE");
            intent2.putExtra("msgIdStr", string);
            intent2.setPackage("android");
            intent2.setFlags(32);
            com.huawei.android.pushagent.c.a.e.a("PushLogAC2705", "send msg response broadcast to frameworkPush");
            context.sendBroadcast(intent2);
        }
    }

    static class HandlePushTokenThread
    extends Thread {
        Context a;
        String b;

        public HandlePushTokenThread(Context context, String string) {
            this.a = context;
            this.b = string;
        }

        @Override
        public void run() {
            h h2 = new h(this.a, "push_client_self_info");
            h2.a("hasRequestToken", false);
            h2.f("token_info");
            f.a(this.a, "push_client_self_info", "token_info", this.b);
        }
    }

    private class EventThread
    extends Thread {
        private Context b;
        private Bundle c;

        public EventThread(Context context, Bundle bundle) {
            super("EventRunable");
            this.b = context;
            this.c = bundle;
        }

        @Override
        public void run() {
            try {
                if (null == this.c) {
                    return;
                }
                int n2 = this.c.getInt("receiveType");
                if (n2 < 0 || n2 >= ReceiveType.values().length) {
                    com.huawei.android.pushagent.c.a.e.d("PushLogAC2705", "invalid receiverType:" + n2);
                    return;
                }
                ReceiveType receiveType = ReceiveType.values()[n2];
                switch (receiveType) {
                    case ReceiveType_Token: {
                        PushReceiver.this.onToken(this.b, this.c.getString("deviceToken"), this.c);
                        break;
                    }
                    case ReceiveType_Msg: {
                        PushReceiver.this.onPushMsg(this.b, this.c.getByteArray("pushMsg"), this.c);
                        break;
                    }
                    case ReceiveType_PushState: {
                        PushReceiver.this.onPushState(this.b, this.c.getBoolean("pushState"));
                        break;
                    }
                    case ReceiveType_NotifyClick: {
                        PushReceiver.this.onEvent(this.b, Event.NOTIFICATION_OPENED, this.c);
                        break;
                    }
                    case ReceiveType_ClickBtn: {
                        PushReceiver.this.onEvent(this.b, Event.NOTIFICATION_CLICK_BTN, this.c);
                        break;
                    }
                    case ReceiveType_PluginRsp: {
                        PushReceiver.this.onEvent(this.b, Event.PLUGINRSP, this.c);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                com.huawei.android.pushagent.c.a.e.c("PushLogAC2705", "call EventThread(ReceiveType cause:" + exception.toString(), exception);
            }
        }
    }

    public static enum Event {
        NOTIFICATION_OPENED,
        PLUGINRSP,
        NOTIFICATION_CLICK_BTN;

    }

    static enum ReceiveType {
        ReceiveType_Init,
        ReceiveType_Token,
        ReceiveType_Msg,
        ReceiveType_PushState,
        ReceiveType_NotifyClick,
        ReceiveType_PluginRsp,
        ReceiveType_ClickBtn;

    }

    public static class BOUND_KEY {
        public static final String deviceTokenKey = "deviceToken";
        public static final String pushMsgKey = "pushMsg";
        public static final String receiveTypeKey = "receiveType";
        public static final String pushStateKey = "pushState";
        public static final String pushNotifyId = "pushNotifyId";
        public static final String PLUGINREPORTRESULT = "isReportSuccess";
        public static final String PLUGINREPORTTYPE = "reportType";
    }
}

