/*
 * Decompiled with CFR 0.152.
 */
package com.peng.one.push.huawei;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.android.pushagent.PushManager;
import com.peng.one.push.cache.OnePushCache;
import com.peng.one.push.core.IPushClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

public class HuaweiPushClient
implements IPushClient {
    private static final String TAG = "HuaweiPushClient";
    private Context mContext;

    public void initContext(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public void register() {
        PushManager.requestToken((Context)this.mContext);
        PushManager.enableReceiveNotifyMsg((Context)this.mContext, (boolean)true);
        PushManager.enableReceiveNormalMsg((Context)this.mContext, (boolean)true);
    }

    public void unRegister() {
        String token = OnePushCache.getToken((Context)this.mContext);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            PushManager.deregisterToken((Context)this.mContext, (String)token);
            PushManager.enableReceiveNotifyMsg((Context)this.mContext, (boolean)false);
            PushManager.enableReceiveNormalMsg((Context)this.mContext, (boolean)false);
            PushManager.deleteTags((Context)this.mContext, Arrays.asList(PushManager.getTags((Context)this.mContext).keySet().toArray()));
            OnePushCache.delToken((Context)this.mContext);
        }
    }

    public void bindAlias(String alias) {
    }

    public void unBindAlias(String alias) {
    }

    public void addTag(String tag) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return;
        }
        HashMap<String, String> tagsMap = new HashMap<String, String>(1);
        tagsMap.put(tag, tag);
        PushManager.setTags((Context)this.mContext, tagsMap);
    }

    public void deleteTag(String tag) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return;
        }
        PushManager.deleteTags((Context)this.mContext, Collections.singletonList(tag));
    }
}

