/*
 * Decompiled with CFR 0.152.
 */
package com.peng.one.push.getui;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import com.igexin.sdk.GTIntentService;
import com.igexin.sdk.message.GTCmdMessage;
import com.igexin.sdk.message.GTTransmitMessage;
import com.peng.one.push.OnePush;
import com.peng.one.push.OneRepeater;
import com.peng.one.push.utils.JsonUtils;
import java.nio.charset.Charset;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class GeTuiReceiverService
extends GTIntentService {
    private Handler retryRegisterHandler = new Handler();

    protected void onHandleIntent(Intent var1) {
        super.onHandleIntent(var1);
    }

    public void onReceiveServicePid(Context context, int pid) {
    }

    public void onReceiveMessageData(Context context, GTTransmitMessage msg) {
        Log.i((String)"GTIntentService", (String)("onReceiveMessageData() called with: context = [" + context + "], msg = [" + msg.getPayload() + "]"));
        String json = new String(msg.getPayload(), Charset.forName("utf-8"));
        Log.i((String)"GTIntentService", (String)("onReceiveMessageData: " + json));
        try {
            JSONObject jsonObject = new JSONObject(json);
            boolean onePush = jsonObject.getBoolean("onePush");
            if (onePush) {
                String title = jsonObject.getString("title");
                String content = jsonObject.getString("content");
                String extraMsg = jsonObject.getString("extraMsg");
                JSONObject keyValue = jsonObject.getJSONObject("keyValue");
                Log.i((String)"GTIntentService", (String)("title:" + title + "  content:" + content + "  extraMsg:" + extraMsg + " keyValue:" + keyValue));
                OneRepeater.transmitNotificationClick((Context)context, (int)0, (String)title, (String)content, (String)extraMsg, (Map)JsonUtils.toMap((JSONObject)keyValue));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            OneRepeater.transmitMessage((Context)context, (String)json, null, null);
        }
    }

    public void onReceiveClientId(Context context, String clientId) {
        OneRepeater.transmitCommandResult((Context)context, (int)2021, (int)200, (String)clientId, null, null);
    }

    public void onReceiveOnlineState(Context context, boolean online) {
        if (!online) {
            this.retryRegisterHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    OnePush.register();
                }
            }, 10000L);
        }
    }

    public void onReceiveCommandResult(Context context, GTCmdMessage cmdMessage) {
        Log.d((String)"GTIntentService", (String)("onReceiveCommandResult() called with: context = [" + context + "], cmdMessage = [" + cmdMessage + "]"));
    }
}

