/*
 * Decompiled with CFR 0.152.
 */
package com.peng.one.push.core;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.peng.one.push.core.IPushClient;
import com.peng.one.push.core.OnOnePushRegisterListener;
import com.peng.one.push.log.OneLog;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OnePushContext {
    private static final String TAG = "OnePushContext";
    private static final String META_DATA_PUSH_HEADER = "OnePush_";
    public static final String METE_DATA_SPLIT_SYMBOL = "_";
    private IPushClient mIPushClient;
    private int mPlatformCode;
    private String mPlatformName;
    private LinkedHashMap<String, String> mAllSupportPushPlatformMap = new LinkedHashMap();

    public static OnePushContext getInstance() {
        return Single.sInstance;
    }

    private OnePushContext() {
    }

    public void init(Application application, OnOnePushRegisterListener listener) {
        Context context = application.getApplicationContext();
        try {
            Set allKeys;
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (metaData != null && (allKeys = metaData.keySet()) != null && !allKeys.isEmpty()) {
                for (String key : allKeys) {
                    if (!key.startsWith(META_DATA_PUSH_HEADER)) continue;
                    this.mAllSupportPushPlatformMap.put(key, metaData.getString(key));
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (this.mAllSupportPushPlatformMap.isEmpty()) {
            throw new IllegalArgumentException("have none push platform,check AndroidManifest.xml is have meta-data name is start with OnePush_");
        }
        for (Map.Entry<String, String> next : this.mAllSupportPushPlatformMap.entrySet()) {
            String metaPlatformName = next.getKey();
            String metaPlatformClassName = next.getValue();
            StringBuilder stringBuilder = new StringBuilder(metaPlatformName).delete(0, 8);
            int len = stringBuilder.length();
            int lastIndexSymbol = stringBuilder.lastIndexOf(METE_DATA_SPLIT_SYMBOL);
            int platformCode = Integer.parseInt(stringBuilder.substring(lastIndexSymbol + 1, len));
            String platformName = stringBuilder.substring(0, lastIndexSymbol);
            try {
                IPushClient iPushClient;
                Class<?> currentClz = Class.forName(metaPlatformClassName);
                Class<?>[] interfaces = currentClz.getInterfaces();
                List<Class<?>> allInterfaces = Arrays.asList(interfaces);
                if (allInterfaces.contains(IPushClient.class)) {
                    iPushClient = (IPushClient)currentClz.newInstance();
                    if (!listener.onRegisterPush(platformCode, platformName)) continue;
                } else {
                    throw new IllegalArgumentException(metaPlatformClassName + "is not implements " + IPushClient.class.getName());
                }
                this.mIPushClient = iPushClient;
                this.mPlatformCode = platformCode;
                this.mPlatformName = platformName;
                OneLog.i("current register platform is " + metaPlatformName);
                iPushClient.initContext((Context)application);
                break;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("can not find class " + metaPlatformClassName);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.mAllSupportPushPlatformMap.clear();
        if (this.mIPushClient == null) {
            throw new IllegalStateException("onRegisterPush must at least one of them returns to true");
        }
    }

    public void register() {
        OneLog.i(String.format("%s--%s", this.getPushPlatFormName(), "register()"));
        this.mIPushClient.register();
    }

    public void unRegister() {
        OneLog.i(String.format("%s--%s", this.getPushPlatFormName(), "unRegister()"));
        this.mIPushClient.unRegister();
    }

    public void bindAlias(String alias) {
        OneLog.i(String.format("%s--%s", this.getPushPlatFormName(), "bindAlias(" + alias + ")"));
        this.mIPushClient.bindAlias(alias);
    }

    public void unBindAlias(String alias) {
        OneLog.i(String.format("%s--%s", this.getPushPlatFormName(), "unBindAlias(" + alias + ")"));
        this.mIPushClient.unBindAlias(alias);
    }

    public void addTag(String tag) {
        OneLog.i(String.format("%s--%s", this.getPushPlatFormName(), "addTag(" + tag + ")"));
        this.mIPushClient.addTag(tag);
    }

    public void deleteTag(String tag) {
        OneLog.i(String.format("%s--%s", this.getPushPlatFormName(), "deleteTag(" + tag + ")"));
        this.mIPushClient.deleteTag(tag);
    }

    public int getPushPlatFormCode() {
        return this.mPlatformCode;
    }

    public String getPushPlatFormName() {
        return this.mPlatformName;
    }

    private static class Single {
        static OnePushContext sInstance = new OnePushContext();

        private Single() {
        }
    }
}

