/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http;

import android.text.TextUtils;
import android.util.Log;
import com.peirr.http.RequestParser;
import com.peirr.http.SocketThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

class ServerRequestHandler
extends Thread {
    String TAG = ServerRequestHandler.class.getSimpleName();
    private Socket toClient;
    private String documentRoot;
    private String html = "<html><body bgcolor=\"#000\" text=\"#fff\">{CONTENT}<body><html>";
    private final int BUFFER_SIZE = 16384;

    public ServerRequestHandler(String d, Socket s) {
        this.toClient = s;
        this.documentRoot = d;
    }

    @Override
    public void run() {
        String path = "";
        try {
            if (!this.toClient.isClosed()) {
                RequestParser parser2 = new RequestParser(this.toClient.getInputStream());
                parser2.parseRequest();
                path = parser2.getRequestURL();
                Log.d((String)this.TAG, (String)("M[ " + parser2.getMethod() + "] [path:" + path + "]"));
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"error reading request: ", (Throwable)e);
            SocketThread.remove(this.toClient);
            try {
                this.toClient.close();
            }
            catch (Exception ex) {
                Log.e((String)this.TAG, (String)"error closing client: ", (Throwable)ex);
            }
        }
        this.process(path);
    }

    public void release() {
        if (this.toClient != null) {
            try {
                this.toClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void process(String path) {
        File f;
        Log.d((String)this.TAG, (String)("process [path:" + path + "]"));
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = "index.html";
        }
        if (path.contains("..")) {
            path = "403.html";
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)this.TAG, (String)"failed to decode path", (Throwable)e);
        }
        path = this.documentRoot + path;
        path = path.replaceAll("[/]+", "/");
        if (path.charAt(path.length() - 1) == '/') {
            path = this.documentRoot + "404.html";
        }
        String header = this.getHeaderBase(path);
        header = header.replace("%code%", "403 Forbidden");
        try {
            f = new File(path);
            if (!f.exists()) {
                header = this.getHeaderBase(path);
                header = header.replace("%code%", "404 File not found");
                path = "404.html";
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        if (!path.equals(this.documentRoot + "403.html")) {
            header = this.getHeaderBase(path).replace("%code%", "200 OK");
        }
        try {
            f = new File(path);
            if (f.exists()) {
                Log.d((String)this.TAG, (String)("FOUND [" + path + "]"));
                header = header.replace("%code%", "200");
                header = header.replace("%length%", "" + f.length());
                FileInputStream fis = new FileInputStream(f);
                OutputStream os = this.toClient.getOutputStream();
                os.write(header.getBytes());
                this.copy(fis, os);
                fis.close();
            } else {
                Log.d((String)this.TAG, (String)("NOT FOUND [" + path + "]"));
                header = this.getHeaderBase(path);
                header = header.replace("%code%", "404");
                header = header.replace("%length%", "" + this.get404().length());
                PrintWriter out = new PrintWriter(this.toClient.getOutputStream(), true);
                out.print(header);
                out.print(this.get404());
                out.flush();
            }
            SocketThread.remove(this.toClient);
            this.toClient.close();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    private String get404() {
        return this.html.replace("{CONTENT}", "");
    }

    private String getHeaderBase(String path) {
        return "HTTP/1.1 %code%\nContent-Type: " + this.getMimeType(path) + "\nContent-Length: " + this.getContentLength(path) + "\nX-Cache: HIT\nAccept-Ranges: bytes\nContent-Encoding: identity\nConnection: close\nAccess-Control-Allow-Origin: *\nSimpleHttpService: Kurt.Mbanje/1.0\n\n";
    }

    private String getDefaultHeaders(String origin) {
        return "HTTP/1.1 200\nContent-Type: text/html; charset=utf-8\nAccess-Control-Allow-Origin: " + origin + "\nSimpleHttpService: Kurt.Mbanje/1.0\n\n";
    }

    public String getMimeType(String url) {
        File file = new File(url);
        String type = URLConnection.guessContentTypeFromName(file.getAbsolutePath());
        Log.d((String)this.TAG, (String)("getMimeType() [url: " + url + "] [type: " + type + "]"));
        return type;
    }

    public String getContentLength(String url) {
        File file = new File(url);
        return String.valueOf(file.length());
    }

    private void copy(InputStream src, OutputStream dest) throws IOException {
        ReadableByteChannel inputChannel = Channels.newChannel(src);
        WritableByteChannel outputChannel = Channels.newChannel(dest);
        this.copy(inputChannel, outputChannel);
    }

    private void copy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    void okioCopy(InputStream in, OutputStream out) throws IOException {
    }
}

