/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public class RequestParser {
    private static final String[][] HttpReplies = new String[][]{{"100", "Continue"}, {"101", "Switching Protocols"}, {"200", "OK"}, {"201", "Created"}, {"202", "Accepted"}, {"203", "Non-Authoritative Information"}, {"204", "No Content"}, {"205", "Reset Content"}, {"206", "Partial Content"}, {"300", "Multiple Choices"}, {"301", "Moved Permanently"}, {"302", "Found"}, {"303", "See Other"}, {"304", "Not Modified"}, {"305", "Use Proxy"}, {"306", "(Unused)"}, {"307", "Temporary Redirect"}, {"400", "Bad Request"}, {"401", "Unauthorized"}, {"402", "Payment Required"}, {"403", "Forbidden"}, {"404", "Not Found"}, {"405", "Method Not Allowed"}, {"406", "Not Acceptable"}, {"407", "Proxy Authentication Required"}, {"408", "Request Timeout"}, {"409", "Conflict"}, {"410", "Gone"}, {"411", "Length Required"}, {"412", "Precondition Failed"}, {"413", "Request Entity Too Large"}, {"414", "Request-URI Too Long"}, {"415", "Unsupported Media Type"}, {"416", "Requested Range Not Satisfiable"}, {"417", "Expectation Failed"}, {"500", "Internal Server Error"}, {"501", "Not Implemented"}, {"502", "Bad Gateway"}, {"503", "Service Unavailable"}, {"504", "Gateway Timeout"}, {"505", "HTTP Version Not Supported"}};
    private BufferedReader reader;
    private String method;
    private String url;
    private Hashtable headers;
    private Hashtable params;
    private int[] ver;

    public RequestParser(InputStream is) {
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.method = "";
        this.url = "";
        this.headers = new Hashtable();
        this.params = new Hashtable();
        this.ver = new int[2];
    }

    public int parseRequest() throws IOException {
        int ret = 200;
        String initial = this.reader.readLine();
        if (initial == null || initial.length() == 0) {
            return 0;
        }
        if (Character.isWhitespace(initial.charAt(0))) {
            return 400;
        }
        String[] cmd = initial.split("\\s");
        if (cmd.length != 3) {
            return 400;
        }
        if (cmd[2].indexOf("HTTP/") == 0 && cmd[2].indexOf(46) > 5) {
            String[] temp = cmd[2].substring(5).split("\\.");
            try {
                this.ver[0] = Integer.parseInt(temp[0]);
                this.ver[1] = Integer.parseInt(temp[1]);
            }
            catch (NumberFormatException nfe) {
                ret = 400;
            }
        } else {
            ret = 400;
        }
        if (cmd[0].equals("GET") || cmd[0].equals("HEAD")) {
            this.method = cmd[0];
            int idx = cmd[1].indexOf(63);
            if (idx < 0) {
                this.url = cmd[1];
            } else {
                this.url = URLDecoder.decode(cmd[1].substring(0, idx), "ISO-8859-1");
                String[] prms = cmd[1].substring(idx + 1).split("&");
                this.parseGetParams(prms);
            }
            this.parseHeaders();
            if (this.headers == null) {
                ret = 400;
            }
        } else if (cmd[0].equals("POST")) {
            this.method = cmd[0];
            int idx = cmd[1].indexOf(63);
            if (idx < 0) {
                this.url = cmd[1];
            } else {
                this.url = URLDecoder.decode(cmd[1].substring(0, idx), "ISO-8859-1");
                String[] prms = cmd[1].substring(idx + 1).split("&");
                this.parseGetParams(prms);
            }
            this.parseHeaders();
            if (this.headers == null) {
                ret = 400;
            }
        } else if (this.ver[0] == 1 && this.ver[1] >= 1) {
            if (cmd[0].equals("OPTIONS") || cmd[0].equals("PUT") || cmd[0].equals("DELETE") || cmd[0].equals("TRACE") || cmd[0].equals("CONNECT")) {
                this.method = cmd[0];
                int idx = cmd[1].indexOf(63);
                if (idx < 0) {
                    this.url = cmd[1];
                } else {
                    this.url = URLDecoder.decode(cmd[1].substring(0, idx), "ISO-8859-1");
                    String[] prms = cmd[1].substring(idx + 1).split("&");
                    this.parseGetParams(prms);
                }
                this.parseHeaders();
                if (this.headers == null) {
                    ret = 400;
                }
            }
        } else {
            ret = 400;
        }
        if (this.ver[0] == 1 && this.ver[1] >= 1 && this.getHeader("Host") == null) {
            ret = 400;
        }
        return ret;
    }

    private void parseGetParams(String[] prms) throws UnsupportedEncodingException {
        this.params = new Hashtable();
        for (int i = 0; i < prms.length; ++i) {
            String[] temp = prms[i].split("=");
            if (temp.length == 2) {
                this.params.put(URLDecoder.decode(temp[0], "ISO-8859-1"), URLDecoder.decode(temp[1], "ISO-8859-1"));
                continue;
            }
            if (temp.length != 1 || prms[i].indexOf(61) != prms[i].length() - 1) continue;
            this.params.put(URLDecoder.decode(temp[0], "ISO-8859-1"), "");
        }
    }

    private void parseHeaders() throws IOException {
        String line = this.reader.readLine();
        while (!line.equals("")) {
            int idx = line.indexOf(58);
            if (idx < 0) {
                this.headers = null;
                break;
            }
            this.headers.put(line.substring(0, idx).toLowerCase(), line.substring(idx + 1).trim());
            line = this.reader.readLine();
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeader(String key) {
        if (this.headers != null) {
            return (String)this.headers.get(key.toLowerCase());
        }
        return null;
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public String getRequestURL() {
        return this.url;
    }

    public String getParam(String key) {
        return (String)this.params.get(key);
    }

    public Hashtable getParams() {
        return this.params;
    }

    public String getVersion() {
        return this.ver[0] + "." + this.ver[1];
    }

    public int compareVersion(int major, int minor) {
        if (major < this.ver[0]) {
            return -1;
        }
        if (major > this.ver[0]) {
            return 1;
        }
        if (minor < this.ver[1]) {
            return -1;
        }
        if (minor > this.ver[1]) {
            return 1;
        }
        return 0;
    }

    public static String getHttpReply(int codevalue) {
        String ret = null;
        String key = "" + codevalue;
        for (int i = 0; i < HttpReplies.length; ++i) {
            if (!HttpReplies[i][0].equals(key)) continue;
            ret = codevalue + " " + HttpReplies[i][1];
            break;
        }
        return ret;
    }

    public static String getDateHeader() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String ret = "Date: " + format.format(new Date()) + " GMT";
        return ret;
    }
}

