/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http;

import com.peirr.http.HttpContract;
import com.peirr.http.IServerRequest;
import com.peirr.http.service.ISimpleHttpServiceServer;
import com.peirr.http.service.SimpleHttpInfo;
import com.peirr.presentation.BasePresenter;
import com.peirr.presentation.MvpView;

public class HttpPresenter
extends BasePresenter<HttpContract.View>
implements HttpContract.Presenter,
ISimpleHttpServiceServer {
    private final IServerRequest request;

    public HttpPresenter(IServerRequest request) {
        this.request = request;
        request.setListener(this);
    }

    @Override
    public void bootup() {
        this.request.bootup();
    }

    @Override
    public void shutdown() {
        this.request.shutdown();
    }

    @Override
    public void info() {
        this.request.info();
    }

    @Override
    public void connect() {
        this.request.connect();
    }

    @Override
    public void disconnect() {
        this.request.disconnect();
    }

    @Override
    public void startService() {
        this.request.startService();
    }

    @Override
    public void stopService() {
        this.request.stopService();
    }

    @Override
    public void onHttpServerStateChanged(int state, SimpleHttpInfo info) {
        if (this.isViewAttached()) {
            ((HttpContract.View)this.getView()).showHttpStatus(state, info);
        }
    }

    public void onBoundServiceConnectionChanged(boolean connected) {
        if (connected) {
            this.request.info();
        }
    }

    public void attachView(HttpContract.View mvpView) {
        super.attachView((MvpView)mvpView);
        this.connect();
    }

    public void detachView() {
        super.detachView();
        this.disconnect();
    }
}

