/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http.service;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import com.peirr.http.service.ISimpleHttpServiceClient;
import com.peirr.http.service.ISimpleHttpServiceServer;
import com.peirr.http.service.SimpleHttpService;
import com.peirr.http.service.SimpleHttpServiceClientHandler;

public final class SimpleHttpServiceClient
implements ISimpleHttpServiceClient {
    private static Messenger serviceMessenger = null;
    private String TAG = SimpleHttpServiceClient.class.getSimpleName();
    private final Activity parent;
    private final Messenger messenger;
    private boolean bound;
    private ServiceConnection connection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            serviceMessenger = new Messenger(service);
            SimpleHttpServiceClient.this.bound = true;
            Log.d((String)SimpleHttpServiceClient.this.TAG, (String)"service connected");
            SimpleHttpServiceClient.this.send(Message.obtain(null, (int)-10));
        }

        public void onServiceDisconnected(ComponentName className) {
            serviceMessenger = null;
            Log.d((String)SimpleHttpServiceClient.this.TAG, (String)"service disconnected");
        }
    };

    private SimpleHttpServiceClient(Activity activity, ISimpleHttpServiceServer stub) {
        this.parent = activity;
        this.messenger = new Messenger((Handler)new SimpleHttpServiceClientHandler(stub));
    }

    public static SimpleHttpServiceClient createStub(Activity parent, ISimpleHttpServiceServer stub) {
        return new SimpleHttpServiceClient(parent, stub);
    }

    public void disconnect() {
        if (this.bound) {
            if (serviceMessenger != null) {
                this.send(Message.obtain(null, (int)-20));
            }
            this.parent.unbindService(this.connection);
            this.bound = false;
            Log.d((String)this.TAG, (String)"disconnecting..");
        }
    }

    public void connect() {
        if (!this.bound) {
            this.parent.bindService(new Intent((Context)this.parent, SimpleHttpService.class), this.connection, 1);
            Log.d((String)this.TAG, (String)"connecting..");
        } else {
            Log.d((String)this.TAG, (String)"not bound not connecting..");
        }
    }

    private boolean send(Message message) {
        if (this.bound) {
            try {
                message.replyTo = this.messenger;
                serviceMessenger.send(message);
                return true;
            }
            catch (RemoteException e) {
                Log.e((String)this.TAG, (String)"error sending message: ", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void bootup(int port) {
        this.send(Message.obtain(null, (int)12, (Object)port));
    }

    @Override
    public void shutdown() {
        this.send(Message.obtain(null, (int)14, null));
    }

    @Override
    public void info(int port) {
        this.send(Message.obtain(null, (int)16, (Object)port));
    }
}

