/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.peirr.http.SocketThread;
import com.peirr.http.service.ISimpleHttpServiceClient;
import com.peirr.http.service.SimpleHttpInfo;
import com.peirr.http.service.SimpleHttpServiceConnector;
import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import mbanje.kurt.remote_service.RemoteService;
import mbanje.kurt.remote_service.RemoteServiceType;

@RemoteService(value=RemoteServiceType.STARTED_BOUND)
public class SimpleHttpService
extends Service
implements ISimpleHttpServiceClient {
    String TAG = SimpleHttpService.class.getSimpleName();
    public static final int STATE_RUNNING = 1;
    public static final int STATE_STOPPED = 2;
    public static final int STATE_ERROR = 3;
    public static final int REQUEST_START = 12;
    public static final int REQUEST_STOP = 14;
    public static final int REQUEST_INFO = 16;
    private static final int PORT_MIN = 9950;
    private static final int PORT_MAX = 9999;
    public static final String COMMAND = "command";
    public static final int CMD_SHUTDOWN = 20;
    public static final int CMD_BOOTUP = 22;
    private String ip;
    private static int port = -1;
    private SimpleHttpServiceConnector connector;
    private SocketThread server;
    private String serverRoot = "";
    private Handler serverHandler = new ServerHandler(this);
    private static SecureRandom random = new SecureRandom();
    private int currentState = 2;
    private String message = null;

    public SimpleHttpService() {
        this.connector = new SimpleHttpServiceConnector(this);
    }

    public IBinder onBind(Intent intent) {
        return this.connector.getBinder();
    }

    public void onCreate() {
        super.onCreate();
        port = SimpleHttpService.generatePort();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            int command = intent.getIntExtra(COMMAND, -1);
            switch (command) {
                case 22: {
                    this.bootup(port);
                    break;
                }
                case 20: {
                    this.shutdown();
                }
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void bootup(int port) {
        Log.d((String)this.TAG, (String)"bootup()");
        try {
            if (port != 0) {
                SimpleHttpService.port = port;
            }
            SimpleHttpInfo info = SimpleHttpService.getInfo((Context)this, this.ip, SimpleHttpService.port);
            this.ip = info.ip;
            this.server = new SocketThread(this.serverHandler, this.serverRoot, info.ip, info.port);
            this.server.start();
            this.currentState = 1;
            Log.d((String)this.TAG, (String)"boot success...");
        }
        catch (Exception e) {
            this.currentState = 3;
            this.message = e.getMessage();
            Log.d((String)this.TAG, (String)"boot failure...");
            Log.e((String)this.TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        this.connector.send(this.currentState, new SimpleHttpInfo(this.ip, port, this.message));
    }

    @Override
    public void shutdown() {
        Log.d((String)this.TAG, (String)"shutdown()");
        this.currentState = 2;
        if (this.server != null) {
            this.server.stopServer();
        }
        SimpleHttpInfo info = SimpleHttpService.getInfo((Context)this, this.ip, port);
        this.ip = info.ip;
        this.connector.send(2, info);
        this.server = null;
        this.stopSelf();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.currentState == 1) {
            this.shutdown();
        }
    }

    @Override
    public void info(int port) {
        if (port != 0) {
            SimpleHttpService.port = port;
        }
        Log.d((String)this.TAG, (String)"info()");
        SimpleHttpInfo info = SimpleHttpService.getInfo((Context)this, this.ip, port);
        this.ip = info.ip;
        this.connector.send(this.currentState, info);
    }

    public static String getIp(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo.getSupplicantState() != SupplicantState.COMPLETED) {
            return null;
        }
        return SimpleHttpService.intToIp(wifiInfo.getIpAddress());
    }

    public static int generatePort() {
        if (port != -1) {
            return port;
        }
        return SimpleHttpService.randomPort(9950, 9999);
    }

    public static SimpleHttpInfo getInfo(Context context, String ip, int port) {
        if (TextUtils.isEmpty((CharSequence)ip)) {
            ip = SimpleHttpService.getIp(context);
        }
        return new SimpleHttpInfo(ip, port, null);
    }

    private static String intToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }

    private static int randomPort(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    private static class ServerHandler
    extends Handler {
        final WeakReference<SimpleHttpService> reference;

        private ServerHandler(SimpleHttpService service) {
            this.reference = new WeakReference<SimpleHttpService>(service);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
        }
    }
}

