/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.peirr.http.ServerRequestHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;

public class SocketThread
extends Thread {
    String TAG = SocketThread.class.getSimpleName();
    private ServerSocket listener = null;
    private boolean running = true;
    private String documentRoot;
    private static Handler handler;
    private ServerRequestHandler httpThread;
    public static LinkedList<Socket> clientList;

    public SocketThread(Handler handler, String documentRoot, String ip, int port) throws IOException {
        this.documentRoot = documentRoot;
        SocketThread.handler = handler;
        InetAddress ipadr = InetAddress.getByName(ip);
        this.listener = new ServerSocket(port, 0, ipadr);
    }

    @Override
    public void run() {
        while (this.isRunning()) {
            try {
                SocketThread.send("Waiting for connections");
                Socket client = this.listener.accept();
                SocketThread.send("New connection from " + client.getInetAddress().toString());
                this.httpThread = new ServerRequestHandler(this.documentRoot, client);
                this.httpThread.start();
                clientList.add(client);
            }
            catch (IOException e) {
                SocketThread.send(e.getMessage());
                Log.w((String)this.TAG, (String)"server shutdown ..: ");
            }
        }
    }

    private synchronized void setRunning(boolean running) {
        this.running = running;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public void stopServer() {
        this.setRunning(false);
        try {
            for (Socket client : clientList) {
                client.close();
            }
            this.releaseHttpThread();
            this.listener.close();
        }
        catch (IOException e) {
            SocketThread.send(e.getMessage());
            Log.e((String)this.TAG, (String)("server shutdown error: " + Log.getStackTraceString((Throwable)e)));
        }
    }

    private void releaseHttpThread() {
        if (this.httpThread != null) {
            this.httpThread.release();
            this.httpThread.interrupt();
        }
    }

    public static synchronized void remove(Socket s) {
        SocketThread.send("Closing connection: " + s.getInetAddress().toString());
        clientList.remove(s);
    }

    private static void send(String s) {
        if (s != null) {
            Message msg = new Message();
            Bundle b = new Bundle();
            b.putString("msg", s);
            msg.setData(b);
            handler.sendMessage(msg);
        }
    }

    static {
        clientList = new LinkedList();
    }
}

