/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http;

import android.app.Activity;
import android.content.Intent;
import com.peirr.http.IServerRequest;
import com.peirr.http.service.ISimpleHttpServiceServer;
import com.peirr.http.service.SimpleHttpInfo;
import com.peirr.http.service.SimpleHttpService;
import com.peirr.http.service.SimpleHttpServiceClient;

public class HttpServer
implements IServerRequest,
ISimpleHttpServiceServer {
    private final Activity activity;
    private SimpleHttpServiceClient http;
    private ISimpleHttpServiceServer listener;
    private final int port;

    public HttpServer(Activity activity, int port) {
        this.activity = activity;
        this.port = port;
        this.http = SimpleHttpServiceClient.createStub(activity, this);
    }

    @Override
    public void startService() {
        Intent intent = new Intent(this.activity.getApplicationContext(), SimpleHttpService.class);
        intent.putExtra("command", 22);
        this.activity.startService(intent);
    }

    @Override
    public void stopService() {
        Intent intent = new Intent(this.activity.getApplicationContext(), SimpleHttpService.class);
        intent.putExtra("command", 20);
        this.activity.startService(intent);
    }

    @Override
    public void bootup() {
        this.http.bootup(this.port);
    }

    @Override
    public void shutdown() {
        this.http.shutdown();
    }

    @Override
    public void info() {
        this.http.info(this.port);
    }

    @Override
    public void connect() {
        this.http.connect();
    }

    @Override
    public void disconnect() {
        this.http.disconnect();
    }

    @Override
    public void onHttpServerStateChanged(int state, SimpleHttpInfo info) {
        if (this.listener != null) {
            this.listener.onHttpServerStateChanged(state, info);
        }
    }

    public void onBoundServiceConnectionChanged(boolean connected) {
        if (this.listener != null) {
            this.listener.onBoundServiceConnectionChanged(connected);
        }
    }

    @Override
    public void setListener(ISimpleHttpServiceServer listener) {
        this.listener = listener;
    }
}

