/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http.mvp;

import android.app.Activity;
import com.peirr.http.mvp.HttpRepository;
import com.peirr.http.service.ISimpleHttpServiceServer;
import com.peirr.http.service.SimpleHttpInfo;
import com.peirr.http.service.SimpleHttpServiceClient;

public class HttpRepositories
implements HttpRepository,
ISimpleHttpServiceServer {
    private final Activity activity;
    private SimpleHttpServiceClient http;
    private ISimpleHttpServiceServer listener;
    private final int port;

    public HttpRepositories(Activity activity, int port) {
        this.activity = activity;
        this.port = port;
        this.http = SimpleHttpServiceClient.createStub(activity, this);
    }

    @Override
    public void bootup() {
        this.http.bootup(this.port);
    }

    @Override
    public void shutdown() {
        this.http.shutdown();
    }

    @Override
    public void info() {
        this.http.info(this.port);
    }

    @Override
    public void connect() {
        this.http.connect();
    }

    @Override
    public void disconnect() {
        this.http.disconnect();
    }

    @Override
    public void onHttpServerStateChanged(int state, SimpleHttpInfo info) {
        if (this.listener != null) {
            this.listener.onHttpServerStateChanged(state, info);
        }
    }

    public void onBoundServiceConnectionChanged(boolean connected) {
        if (this.listener != null) {
            this.listener.onBoundServiceConnectionChanged(connected);
        }
    }

    @Override
    public void setListener(ISimpleHttpServiceServer listener) {
        this.listener = listener;
    }
}

