/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.peirr.http.SimpleHttpServer;
import com.peirr.http.utils.IO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;

class SimpleHttpServerHandler
extends Thread {
    String TAG = SimpleHttpServerHandler.class.getSimpleName();
    private Socket toClient;
    private String documentRoot;
    private Context context;
    private String html = "<html><body bgcolor=\"#000\" text=\"#fff\">{CONTENT}<body><html>";
    private final int BUFFER_SIZE = 1024;

    public SimpleHttpServerHandler(String d, Context c, Socket s) {
        this.toClient = s;
        this.documentRoot = d;
        this.context = c;
    }

    @Override
    public void run() {
        String path = "";
        try {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.toClient.getInputStream()));
            while (!(s = in.readLine().trim()).equals("")) {
                if (!s.substring(0, 3).equals("GET")) continue;
                int leerstelle = s.indexOf(" HTTP/");
                path = s.substring(5, leerstelle);
                path = path.replaceAll("[/]+", "/");
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"reading buffer: ", (Throwable)e);
            SimpleHttpServer.remove(this.toClient);
            try {
                this.toClient.close();
            }
            catch (Exception ex) {
                Log.e((String)this.TAG, (String)"error closing client: ", (Throwable)ex);
            }
        }
        this.get(path);
    }

    public void release() {
        if (this.toClient != null) {
            try {
                this.toClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void get(String path) {
        File f;
        Log.d((String)this.TAG, (String)("GET [path:" + path + "]"));
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = "index.html";
        }
        if (path.contains("..")) {
            path = "403.html";
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)this.TAG, (String)"failed to decode path", (Throwable)e);
        }
        path = this.documentRoot + path;
        Log.d((String)this.TAG, (String)("file: " + path));
        path = path.replaceAll("[/]+", "/");
        if (path.charAt(path.length() - 1) == '/') {
            path = this.documentRoot + "404.html";
        }
        String header = this.getHeaderBase(path);
        header = header.replace("%code%", "403 Forbidden");
        try {
            f = new File(path);
            if (!f.exists()) {
                header = this.getHeaderBase(path);
                header = header.replace("%code%", "404 File not found");
                path = "404.html";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!path.equals(this.documentRoot + "403.html")) {
            header = this.getHeaderBase(path).replace("%code%", "200 OK");
        }
        Log.d((String)this.TAG, (String)("Serving " + path));
        try {
            f = new File(path);
            if (f.exists()) {
                header = header.replace("%length%", "" + f.length());
                FileInputStream fis = new FileInputStream(f);
                OutputStream os = this.toClient.getOutputStream();
                os.write(header.getBytes());
                IO.bufferSize = 1024;
                IO.copy(fis, os);
                fis.close();
            } else {
                header = this.getHeaderBase(path);
                header = header.replace("%code%", "404 File not found");
                header = header.replace("%length%", "" + this.get404().length());
                PrintWriter out = new PrintWriter(this.toClient.getOutputStream(), true);
                out.print(header);
                out.print(this.get404());
                out.flush();
            }
            SimpleHttpServer.remove(this.toClient);
            this.toClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String get404() {
        return this.html.replace("{CONTENT}", "");
    }

    private String getHeaderBase(String path) {
        return "HTTP/1.1 %code%\nContent-Type: " + this.getMimeType(path) + "\n" + "X-Cache: HIT\n" + "Content-Length: %length%\n" + "Accept-Ranges: bytes\n" + "Cache-Control: no-cache\n" + "Pragma: no-cache\n" + "Content-Encoding: identity\n" + "Connection: close\n" + "Access-Control-Allow-Origin: *\n" + "SimpleHttpService: SimpleHttpService/1.0\n\n";
    }

    public String getMimeType(String url) {
        String type = "text/html";
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (!TextUtils.isEmpty((CharSequence)extension)) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            type = mime.getMimeTypeFromExtension(extension);
        }
        return type;
    }
}

