/*
 * Decompiled with CFR 0.152.
 */
package com.peirr.http;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.peirr.http.SimpleHttpServerHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;

public class SimpleHttpServer
extends Thread {
    String TAG = SimpleHttpServer.class.getSimpleName();
    private ServerSocket listener = null;
    private boolean running = true;
    private String documentRoot;
    private static Handler handler;
    private Context context;
    private SimpleHttpServerHandler httpThread;
    public static LinkedList<Socket> clientList;

    public SimpleHttpServer(Handler handler, String documentRoot, String ip, int port, Context context) throws IOException {
        this.documentRoot = documentRoot;
        this.context = context;
        SimpleHttpServer.handler = handler;
        InetAddress ipadr = InetAddress.getByName(ip);
        this.listener = new ServerSocket(port, 0, ipadr);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                SimpleHttpServer.send("Waiting for connections");
                Socket client = this.listener.accept();
                SimpleHttpServer.send("New connection from " + client.getInetAddress().toString());
                this.releaseHttpThread();
                this.httpThread = new SimpleHttpServerHandler(this.documentRoot, this.context, client);
                this.httpThread.start();
                clientList.add(client);
            }
            catch (IOException e) {
                SimpleHttpServer.send(e.getMessage());
                Log.e((String)this.TAG, (String)("server boot error: " + Log.getStackTraceString((Throwable)e)));
            }
        }
    }

    public void stopServer() {
        this.running = false;
        try {
            this.releaseHttpThread();
            this.listener.close();
        }
        catch (IOException e) {
            SimpleHttpServer.send(e.getMessage());
            Log.e((String)this.TAG, (String)("server shutdown error: " + Log.getStackTraceString((Throwable)e)));
        }
    }

    private void releaseHttpThread() {
        if (this.httpThread != null) {
            this.httpThread.release();
            this.httpThread.interrupt();
        }
    }

    public static synchronized void remove(Socket s) {
        SimpleHttpServer.send("Closing connection: " + s.getInetAddress().toString());
        clientList.remove(s);
    }

    private static void send(String s) {
        if (s != null) {
            Message msg = new Message();
            Bundle b = new Bundle();
            b.putString("msg", s);
            msg.setData(b);
            handler.sendMessage(msg);
        }
    }

    static {
        clientList = new LinkedList();
    }
}

