/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.simplejson;

import com.pecpwee.lib.simplejson.Token;

class JsonTokenReader {
    private String mJsonStr;
    private int mIndex;

    public JsonTokenReader(String jsonStr) {
        this.mJsonStr = jsonStr;
        this.mIndex = -1;
    }

    private char getNextChar() {
        ++this.mIndex;
        return this.mJsonStr.charAt(this.mIndex);
    }

    private void revokeCharRead() {
        --this.mIndex;
    }

    public Token getNextToken() {
        if (this.mIndex + 1 >= this.mJsonStr.length()) {
            return new Token(10, "EOF");
        }
        char c = this.getNextChar();
        Token resultToken = null;
        if (this.isFitPatternStr(c, "null")) {
            resultToken = new Token(4, null);
        } else if (c == ',') {
            resultToken = new Token(9, ",");
        } else if (c == ':') {
            resultToken = new Token(8, ":");
        } else if (c == '{') {
            resultToken = new Token(0, "{");
        } else if (c == '[') {
            resultToken = new Token(2, "[");
        } else if (c == ']') {
            resultToken = new Token(3, "]");
        } else if (c == '}') {
            resultToken = new Token(1, "}");
        } else if (this.isFitPatternStr(c, "true")) {
            resultToken = new Token(7, "true");
        } else if (this.isFitPatternStr(c, "false")) {
            resultToken = new Token(7, "false");
        } else if (c == '\"') {
            resultToken = this.readString();
        } else if (Character.isDigit(c) || c == '-') {
            resultToken = this.readNum(c);
        } else {
            this.throwParseError();
        }
        return resultToken;
    }

    private boolean isASCControlChar(char c) {
        return c < ' ' || c == '\u007f';
    }

    private Token readNum(char firstchar) {
        StringBuilder numConstructCache = new StringBuilder();
        char c = firstchar;
        while (true) {
            if (!this.isLegalNumChar(c)) break;
            numConstructCache.append(c);
            c = this.getNextChar();
        }
        this.revokeCharRead();
        return new Token(5, numConstructCache.toString());
    }

    private boolean isLegalNumChar(char c) {
        return c == '-' || c == '+' || c >= '0' && c <= '9' || c == 'e' || c == 'E' || c == '.';
    }

    private boolean isFitPatternStr(char startC, String patternStr) {
        if (startC != patternStr.charAt(0)) {
            return false;
        }
        int inputChar = 32;
        int patternchar = 32;
        for (int i = 1; i < patternStr.length(); ++i) {
            patternchar = patternStr.charAt(i);
            inputChar = this.getNextChar();
            if (inputChar == patternchar) continue;
            this.throwParseError();
        }
        return true;
    }

    private Token readString() {
        StringBuilder sb = new StringBuilder();
        while (true) {
            char c;
            if ((c = this.getNextChar()) == '\\') {
                sb.append(this.getUnescapeChar());
                continue;
            }
            if (c == '\"') break;
            if (c == '\r' || c == '\n') {
                this.throwParseError();
                continue;
            }
            sb.append(c);
        }
        return new Token(6, sb.toString());
    }

    private char getUnescapeChar() {
        char c = this.getNextChar();
        switch (c) {
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '/': {
                return '/';
            }
            case 'u': {
                StringBuilder unicodesb = new StringBuilder();
                for (int i = 0; i < 4; ++i) {
                    unicodesb.append(this.getNextChar());
                }
                return (char)Integer.parseInt(unicodesb.toString(), 16);
            }
        }
        this.throwParseError();
        this.throwParseError();
        return '\u0000';
    }

    private void throwParseError() {
        throw new IllegalArgumentException("illegal JSON String.the error happend in the end of:" + this.mJsonStr.substring(0, this.mIndex));
    }
}

