/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.simplejson;

import com.pecpwee.lib.simplejson.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

class WriteOperator {
    WriteOperator() {
    }

    public void dispatchParse(StringBuilder sb, Object object) {
        if (object == null) {
            sb.append("null");
            return;
        }
        Class<?> objType = object.getClass();
        if (objType == Byte.TYPE || objType == Byte.class) {
            sb.append(((Byte)object).byteValue());
        } else if (objType == Short.TYPE || objType == Short.class) {
            sb.append(((Short)object).shortValue());
        } else if (objType == Integer.TYPE || objType == Integer.class) {
            sb.append((Integer)object);
        } else if (objType == Long.TYPE || objType == Long.class) {
            sb.append((Long)object);
        } else if (objType == Float.TYPE || objType == Float.class) {
            sb.append(((Float)object).floatValue());
        } else if (objType == Double.TYPE || objType == Double.class) {
            sb.append((Double)object);
        } else if (objType == String.class) {
            this.writeString((String)object, sb);
        } else if (objType == Boolean.TYPE || objType == Boolean.class) {
            sb.append((Boolean)object);
        } else if (Utils.isListObject(object.getClass())) {
            this.parseList(object, sb);
        } else if (objType.isArray()) {
            this.parseArray(object, sb);
        } else {
            this.parseObj(object, sb);
        }
    }

    private void writeString(String object, StringBuilder sb) {
        sb.append("\"");
        this.appendEscapeString(object, sb);
        sb.append("\"");
    }

    private void appendEscapeString(String s, StringBuilder sb) {
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        this.appendHexUnicode(ch, sb);
                        continue block9;
                    }
                    if (ch == '&' || ch == '<' || ch == '>' || ch == '\\' || ch == '\'') {
                        this.appendHexUnicode(ch, sb);
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
    }

    private void appendHexUnicode(char ch, StringBuilder sb) {
        String ss = Integer.toHexString(ch);
        sb.append("\\u");
        for (int k = 0; k < 4 - ss.length(); ++k) {
            sb.append('0');
        }
        sb.append(ss.toLowerCase());
    }

    private void parseList(Object object, StringBuilder sb) {
        List listObj = null;
        listObj = (List)object;
        if (listObj == null) {
            throw new RuntimeException("list not support");
        }
        sb.append("[");
        for (Object item : listObj) {
            this.dispatchParse(sb, item);
            sb.append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
    }

    private void parseArray(Object object, StringBuilder sb) {
        int arrLength = Array.getLength(object);
        sb.append("[");
        for (int i = 0; i < arrLength; ++i) {
            Object arrListObj = Array.get(object, i);
            this.dispatchParse(sb, arrListObj);
            sb.append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
    }

    private void parseObj(Object object, StringBuilder sb) {
        sb.append("{");
        Class<?> currentLevelClass = object.getClass();
        do {
            this.parseObjField(currentLevelClass, object, sb);
        } while ((currentLevelClass = currentLevelClass.getSuperclass()) != null);
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
    }

    private void parseObjField(Class currentLevelClazz, Object object, StringBuilder sb) {
        Field[] fields;
        for (Field field : fields = currentLevelClazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (this.shouldSkipField(object, field)) continue;
            this.parseFieldName(field, sb);
            sb.append(":");
            this.parseFieldValue(field, object, sb);
            sb.append(",");
        }
    }

    private boolean shouldSkipField(Object object, Field field) {
        Object fieldObj = null;
        try {
            fieldObj = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        int mod = field.getModifiers();
        return fieldObj == null || Modifier.isStatic(mod) || Modifier.isTransient(mod) || Modifier.isFinal(mod);
    }

    private void parseFieldName(Field field, StringBuilder sb) {
        sb.append("\"").append(field.getName()).append("\"");
    }

    private void parseFieldValue(Field field, Object object, StringBuilder sb) {
        try {
            this.dispatchParse(sb, field.get(object));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

