/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.simplejson;

import com.pecpwee.lib.simplejson.JsonTokenReader;
import com.pecpwee.lib.simplejson.Token;
import com.pecpwee.lib.simplejson.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ReadOperator<T> {
    private JsonTokenReader reader;

    public ReadOperator(JsonTokenReader reader) {
        this.reader = reader;
    }

    private Token getNextToken() {
        Token token = this.reader.getNextToken();
        if (token.type == 10) {
            this.throwTokenError();
        }
        return token;
    }

    private Object readObj(Class clazz, Token startToken) {
        block13: {
            if (startToken.type != 0) {
                this.throwTokenError();
            }
            Token token = null;
            Object instanceObj = Utils.createInstance(clazz);
            token = this.getNextToken();
            if (token.type == 1) {
                return instanceObj;
            }
            while (true) {
                String memberName = null;
                if (token.type == 6) {
                    memberName = token.value;
                } else {
                    this.throwTokenError();
                }
                token = this.getNextToken();
                if (token.type != 8) {
                    this.throwTokenError();
                }
                Field memberField = null;
                if (memberName == null) break block13;
                try {
                    memberField = instanceObj.getClass().getDeclaredField(memberName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (memberField != null) {
                    memberField.setAccessible(true);
                    Object fieldValueObj = this.dispatchParse(memberField.getType(), memberField, null);
                    try {
                        memberField.set(instanceObj, fieldValueObj);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.consumeTheFieldValue();
                }
                token = this.getNextToken();
                if (token.type == 9) {
                    token = this.getNextToken();
                    continue;
                }
                if (token.type == 1) break;
            }
            return instanceObj;
        }
        this.throwTokenError();
        return null;
    }

    public Object dispatchParse(Class clazz, Field field, Token startToken) {
        Token token = startToken;
        if (token == null) {
            token = this.getNextToken();
        }
        if (token.type == 0) {
            return this.readObj(clazz, token);
        }
        if (token.type == 6) {
            return token.value;
        }
        if (token.type == 5) {
            return this.parseNumber(clazz, token);
        }
        if (token.type == 2) {
            return this.parseArrayOrList(clazz, field, token);
        }
        if (token.type == 7) {
            return Boolean.parseBoolean(token.value);
        }
        if (token.type == 4) {
            return null;
        }
        this.throwTokenError();
        return null;
    }

    private void consumeTheFieldValue() {
        Token token = this.getNextToken();
        int startType = -1;
        int endType = -1;
        if (token.type == 2) {
            startType = 2;
            endType = 3;
        } else if (token.type == 0) {
            startType = 0;
            endType = 1;
        } else {
            return;
        }
        int pairCount = 1;
        while (true) {
            token = this.getNextToken();
            if (token.type == startType) {
                ++pairCount;
                continue;
            }
            if (token.type == endType && --pairCount == 0) break;
        }
    }

    private Object parseArrayOrList(Class clazz, Field field, Token startToken) {
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            ArrayList componentValueList = new ArrayList();
            this.parseComponent2List(componentValueList, componentType, startToken);
            Object arrayObj = Array.newInstance(componentType, componentValueList.size());
            for (int i = 0; i < componentValueList.size(); ++i) {
                Array.set(arrayObj, i, componentValueList.get(i));
            }
            return arrayObj;
        }
        if (Utils.isListObject(clazz) && !clazz.isInterface()) {
            List list = (List)Utils.createInstance(clazz);
            Class componentType = Utils.getListComponentType(field);
            this.parseComponent2List(list, componentType, startToken);
            return list;
        }
        if (clazz.isInterface() && clazz == List.class) {
            Class componentType = Utils.getListComponentType(field);
            if (componentType == null) {
                this.throwTokenError();
            }
            ArrayList list = new ArrayList();
            this.parseComponent2List(list, componentType, startToken);
            return list;
        }
        this.throwTokenError();
        return null;
    }

    private void parseComponent2List(List list, Class componentType, Token startToken) {
        if (startToken.type != 2) {
            this.throwTokenError();
        }
        Token token = this.getNextToken();
        if (token.type == 3) {
            return;
        }
        while (true) {
            Object object = this.dispatchParse(componentType, null, token);
            list.add(object);
            token = this.getNextToken();
            if (token.type != 9) break;
            token = this.getNextToken();
        }
        if (token.type == 3) {
            return;
        }
        this.throwTokenError();
    }

    private Object parseNumber(Class clazz, Token startToken) {
        Token token = startToken;
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return Byte.decode(token.value);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return Short.decode(token.value);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.decode(token.value);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Long.decode(token.value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(token.value);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.valueOf(token.value);
        }
        return null;
    }

    private void throwTokenError() {
        throw new IllegalArgumentException("illegal token:");
    }
}

