/*
 * Decompiled with CFR 0.152.
 */
package com.example.uiwrapper;

import android.app.Activity;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.Toast;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.MapView;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import com.example.uiwrapper.MainPannelRepository;
import com.example.uiwrapper.MainPannelStateKeeper;
import com.example.uiwrapper.R;
import com.pecpwee.lib.envmock.PlayController;
import com.pecpwee.lib.envmock.utils.TimerJob;
import java.io.FileNotFoundException;
import java.util.List;

public class MainPannelFragment
extends DialogFragment {
    private MapView mapView;
    private Button btnStart;
    private Button btnStop;
    private Button btnHide;
    private SeekBar progressBar;
    private MainPannelRepository repository;
    private AMap mMapController;
    private Polyline mPathOnMap;
    private Marker mCurrentPlayPositionMarker;
    private TimerJob mUIRefreshTimeJob = new TimerJob().setInterval(400L).setRunnable(new Runnable(){

        @Override
        public void run() {
            MainPannelFragment.this.refreshPlayProgress();
        }
    });
    private static final String FRAGMENT_TAG = "envMockMainPannel";

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.getDialog().setCancelable(false);
        this.getDialog().setCanceledOnTouchOutside(false);
        View view = inflater.inflate(R.layout.fragment_main_panel, container, false);
        this.btnStart = (Button)view.findViewById(R.id.btn_start);
        this.btnStop = (Button)view.findViewById(R.id.btn_stop);
        this.btnHide = (Button)view.findViewById(R.id.btn_hide);
        this.progressBar = (SeekBar)view.findViewById(R.id.progressbar);
        this.btnStart.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MainPannelFragment.this.goStartState();
            }
        });
        this.btnStop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MainPannelFragment.this.goStopState();
            }
        });
        this.btnHide.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MainPannelFragment.this.hide();
            }
        });
        this.progressBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    float offsetPercentage = (float)progress / 100.0f;
                    PlayController.getInstance().setBeginOffsetPercent(offsetPercentage);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.mapView = (MapView)view.findViewById(R.id.map);
        this.mapView.onCreate(savedInstanceState);
        this.mMapController = this.mapView.getMap();
        this.mMapController.getUiSettings().setMyLocationButtonEnabled(false);
        this.mMapController.getUiSettings().setZoomControlsEnabled(false);
        this.mMapController.getUiSettings().setTiltGesturesEnabled(false);
        return view;
    }

    private void goStartState() {
        if (!PlayController.getInstance().isPlaying()) {
            try {
                PlayController.getInstance().startPlay();
            }
            catch (FileNotFoundException e) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"no envMock data file founded, please record some data firstly", (int)0).show();
                return;
            }
        }
        this.setStartUI();
    }

    private void setStartUI() {
        this.drawPath();
        this.progressBar.setEnabled(false);
        this.btnStop.setEnabled(true);
        this.btnStart.setEnabled(false);
        this.mUIRefreshTimeJob.start();
    }

    private void goStopState() {
        if (PlayController.getInstance().isPlaying()) {
            PlayController.getInstance().stopPlay();
        }
        PlayController.getInstance().setBeginOffsetPercent(0.0f);
        this.setStopUI();
    }

    private void setStopUI() {
        if (this.mCurrentPlayPositionMarker != null) {
            this.mCurrentPlayPositionMarker.remove();
            this.mCurrentPlayPositionMarker = null;
        }
        this.mUIRefreshTimeJob.stop();
        this.progressBar.setEnabled(true);
        this.progressBar.setProgress(0);
        this.btnStop.setEnabled(false);
        this.btnStart.setEnabled(true);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.synchronizeUIState();
    }

    public void onPause() {
        super.onPause();
        this.mapView.onPause();
    }

    public void onResume() {
        super.onResume();
        this.mapView.onResume();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mapView.onSaveInstanceState(outState);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mapView.onDestroy();
    }

    private void synchronizeUIState() {
        PlayController controller = PlayController.getInstance();
        this.drawPath();
        if (controller.isPlaying()) {
            this.setStartUI();
            this.refreshPlayProgress();
        } else {
            this.setStopUI();
        }
        this.mMapController.moveCamera(CameraUpdateFactory.zoomTo((float)this.mMapController.getMaxZoomLevel()));
        this.mMapController.moveCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)MainPannelStateKeeper.sUIState.cameraPosition));
    }

    private void refreshPlayProgress() {
        float currentProgress = PlayController.getInstance().getPlayingProgress();
        if (currentProgress == 1.0f) {
            this.goStopState();
        } else {
            this.progressBar.setProgress((int)(PlayController.getInstance().getPlayingProgress() * 100.0f));
            this.setCurrentLocationOnMap(PlayController.getInstance().getLastPlayedLocation());
        }
    }

    private void setCurrentLocationOnMap(Location location) {
        if (location == null) {
            return;
        }
        LatLng latLng = this.repository.convert2AmapLoc(location);
        this.moveCamera(latLng);
        if (this.mCurrentPlayPositionMarker != null) {
            this.mCurrentPlayPositionMarker.remove();
        }
        this.mCurrentPlayPositionMarker = this.mMapController.addMarker(new MarkerOptions().position(latLng).title("played location"));
    }

    private void moveCamera(LatLng latLng) {
        this.mMapController.moveCamera(CameraUpdateFactory.zoomTo((float)this.mMapController.getMaxZoomLevel()));
        this.mMapController.moveCamera(CameraUpdateFactory.changeLatLng((LatLng)latLng));
    }

    private void drawPath() {
        this.repository = new MainPannelRepository(this.getActivity().getApplicationContext());
        List<LatLng> latLngs = this.repository.getPathList();
        if (latLngs == null) {
            return;
        }
        if (this.mPathOnMap != null) {
            this.mPathOnMap.remove();
        }
        this.mPathOnMap = this.mMapController.addPolyline(new PolylineOptions().addAll(latLngs).width(10.0f).color(Color.argb((int)255, (int)255, (int)1, (int)1)));
        if (!PlayController.getInstance().isPlaying() && latLngs.size() > 0) {
            this.moveCamera(latLngs.get(0));
        }
    }

    public void showFragment(Activity activity) {
        FragmentManager fragmentManager = activity.getFragmentManager();
        Fragment existedFragment = fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (existedFragment == null) {
            fragmentManager.beginTransaction().add((Fragment)this, FRAGMENT_TAG).commit();
        } else {
            fragmentManager.beginTransaction().show((Fragment)this).commit();
            this.getDialog().show();
        }
    }

    public void hide() {
        FragmentManager fragmentManager = this.getActivity().getFragmentManager();
        Fragment existedFragment = fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (existedFragment != null) {
            fragmentManager.beginTransaction().hide((Fragment)this).commit();
            this.getDialog().hide();
        }
        MainPannelStateKeeper.sUIState.cameraPosition = this.mMapController.getCameraPosition();
    }

    public void destroy(Activity activity) {
        this.setStopUI();
        FragmentManager fragmentManager = activity.getFragmentManager();
        Fragment existedFragment = fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (existedFragment != null) {
            fragmentManager.beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
    }
}

