/*
 * Decompiled with CFR 0.152.
 */
package com.example.uiwrapper;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.Toast;
import com.example.uiwrapper.FloatView;
import com.example.uiwrapper.MainPannelFragment;
import com.example.uiwrapper.R;
import com.pecpwee.lib.envmock.utils.LogUtils;
import java.util.HashMap;

public class StateManager {
    private static final String TAG = "StateManager ";
    private Activity currentActivity = null;
    private View floatingView;
    ViewGroup.MarginLayoutParams floatingViewParams;
    MainPannelFragment mainFragment;
    HashMap<Activity, FloatView> hashMap;

    public void addFloatingWindow(Activity activity) {
        this.currentActivity = activity;
        ViewGroup contentParentView = (ViewGroup)activity.findViewById(0x1020002);
        for (int i = 0; i < contentParentView.getChildCount(); ++i) {
            if (contentParentView.getChildAt(i) != this.floatingView) continue;
            return;
        }
        final View view = LayoutInflater.from((Context)activity).inflate(R.layout.view_floating_icon, null);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                StateManager.this.showMainWindow();
            }
        });
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                StateManager.this.floatingViewParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            }
        });
        this.floatingView = view;
        LogUtils.d((String)"addFloatingWindow");
        if (this.floatingViewParams != null) {
            activity.addContentView(this.floatingView, (ViewGroup.LayoutParams)this.floatingViewParams);
        } else {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.height = 200;
            params.width = 200;
            activity.addContentView(this.floatingView, (ViewGroup.LayoutParams)params);
        }
    }

    public void removeFloatingWindow(Activity activity) {
        ((ViewGroup)this.floatingView.getParent()).removeView(this.floatingView);
        this.onActivityStop(activity);
    }

    public void showMainWindow() {
        Toast.makeText((Context)this.currentActivity, (CharSequence)"clicked", (int)0).show();
        if (this.mainFragment == null) {
            this.mainFragment = new MainPannelFragment();
        }
        this.mainFragment.showFragment(this.currentActivity);
    }

    public void onActivityStop(Activity activity) {
        if (this.currentActivity == activity) {
            if (this.mainFragment != null) {
                this.mainFragment.destroy(activity);
            }
            this.currentActivity = null;
        }
    }
}

