/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.player;

import com.pecpwee.lib.envmock.player.AbsPlayer;
import com.pecpwee.lib.envmock.player.ILineDataParser;
import com.pecpwee.lib.envmock.utils.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class PlayerDataSource {
    private boolean isDataLoadedOk = false;
    private ArrayList<AbsPlayer.TimedRunnable> mTimedActionsList = new ArrayList();

    void setNeedReloadData() {
        this.isDataLoadedOk = false;
    }

    public boolean isDataLoadedOk() {
        return this.isDataLoadedOk;
    }

    void addTimedAction(AbsPlayer.TimedRunnable timeRunnable) {
        this.mTimedActionsList.add(timeRunnable);
    }

    public int getSize() {
        return this.mTimedActionsList.size();
    }

    public AbsPlayer.TimedRunnable getAction(int index) {
        return this.mTimedActionsList.get(index);
    }

    public synchronized void loadDataIfNeed(File file, ILineDataParser parser) throws FileNotFoundException {
        if (this.isDataLoadedOk) {
            return;
        }
        this.mTimedActionsList.clear();
        this.doLoadData(file, parser);
        this.isDataLoadedOk = true;
    }

    private void doLoadData(File file, ILineDataParser parser) throws FileNotFoundException {
        FileInputStream fis = null;
        if (!file.exists()) {
            throw new FileNotFoundException("cannot find mock data file");
        }
        this.mTimedActionsList.clear();
        LogUtils.d(this.getClass().getSimpleName() + " loading data from" + file.getAbsolutePath());
        try {
            int linecount = 0;
            fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = br.readLine()) != null) {
                parser.onNewLineGot(line);
                ++linecount;
            }
            br.close();
            LogUtils.d(this.getClass().getSimpleName() + "parsed the count of the line is:" + linecount);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

