/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock;

import android.location.Location;
import com.pecpwee.lib.envmock.EnvMockInstaller;
import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.hook.CenterServiceManager;
import com.pecpwee.lib.envmock.player.PlayerManager;
import com.pecpwee.lib.envmock.utils.LogUtils;
import java.io.FileNotFoundException;
import java.util.List;

public class PlayController {
    private boolean isPlaying = false;
    public static PlayController INSTANCE;

    private PlayController() {
    }

    public static synchronized PlayController getInstance() {
        if (!EnvMockInstaller.isPlayServiceInstalled) {
            throw new RuntimeException("you should installed the envMock service first");
        }
        if (PlayConfig.getInstance().isAutoPlayMode()) {
            throw new RuntimeException("in the auto mode,you should not create PlayController that used for manual control.please config before install the service");
        }
        if (INSTANCE == null) {
            INSTANCE = new PlayController();
        }
        return INSTANCE;
    }

    public float getPlayingProgress() {
        try {
            return PlayerManager.getPlayingProgress();
        }
        catch (Exception e) {
            LogUtils.log(e);
            return -1.0f;
        }
    }

    public Location getLastPlayedLocation() {
        return PlayerManager.getLastPlayLocation();
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public synchronized List<Location> getCompletePlayPathLocations() throws FileNotFoundException {
        return PlayerManager.getCompletePlayPathLocations();
    }

    public synchronized void startPlay() throws FileNotFoundException {
        if (this.isPlaying) {
            throw new RuntimeException("you are playing!you should stop the replay before you call play method again");
        }
        this.ensureIsManualMode();
        long time = System.currentTimeMillis();
        PlayerManager.doStartPlay();
        this.isPlaying = true;
    }

    public synchronized void stopPlay() {
        this.ensureIsManualMode();
        if (!this.isPlaying) {
            throw new RuntimeException("there is no module is playing!");
        }
        PlayerManager.doStopPlay();
        this.isPlaying = false;
    }

    public synchronized void setBeginOffsetPercent(float percentOffset) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().setStartPlayPercentage(percentOffset);
    }

    public PlayController setWifiPlayerEnable(boolean isEnable) {
        this.setPlayEnableState("wifi", isEnable);
        return this;
    }

    public PlayController setGpsPlayerEnable(boolean isEnable) {
        this.setPlayEnableState("location", isEnable);
        return this;
    }

    public PlayController setConnPlayerEnable(boolean isEnable) {
        this.setPlayEnableState("connectivity", isEnable);
        return this;
    }

    public PlayController setCellPlayerEnable(boolean isEnable) {
        this.setPlayEnableState("phone", isEnable);
        return this;
    }

    private void setPlayEnableState(String serviceName, boolean state) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().getModuleStateMap().get((Object)serviceName).isPlayEnable = state;
    }

    public PlayController setWifiHookEnable(boolean isEnable) {
        this.setHookEnableState("wifi", isEnable);
        return this;
    }

    public PlayController setGpsHookEnable(boolean isEnable) {
        this.setHookEnableState("location", isEnable);
        return this;
    }

    public PlayController setConnHookEnable(boolean isEnable) {
        this.setHookEnableState("connectivity", isEnable);
        return this;
    }

    public PlayController setCellHookEnable(boolean isEnable) {
        this.setHookEnableState("phone", isEnable);
        return this;
    }

    private void setHookEnableState(String serviceName, boolean state) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().getModuleStateMap().get((Object)serviceName).isHookEnable = state;
    }

    public PlayController setGpsMockFilePath(String filepath) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().setGpsRecordFilePath(filepath);
        CenterServiceManager.getInstance().getServiceFetcher("location").getPlayer().notifyDataSourceChanged();
        return this;
    }

    public PlayController setWifiMockFilePath(String filepath) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().setWifiRecordFilePath(filepath);
        CenterServiceManager.getInstance().getServiceFetcher("wifi").getPlayer().notifyDataSourceChanged();
        return this;
    }

    public PlayController setCellMockFilePath(String filepath) {
        this.ensureNoPlaying();
        this.ensureIsManualMode();
        PlayConfig.getInstance().setCellRecordFilePath(filepath);
        CenterServiceManager.getInstance().getServiceFetcher("phone").getPlayer().notifyDataSourceChanged();
        return this;
    }

    private void ensureNoPlaying() {
        if (this.isPlaying) {
            throw new RuntimeException("you should stop the playing before setting ");
        }
    }

    private void ensureIsManualMode() {
        if (PlayConfig.getInstance().isAutoMode()) {
            throw new RuntimeException("you should not in auto mode ");
        }
    }
}

