/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.RecordConfig;
import com.pecpwee.lib.envmock.hook.AbsServiceFetcher;
import com.pecpwee.lib.envmock.hook.CenterServiceManager;
import com.pecpwee.lib.envmock.middle.connect.ConnectivityServiceFactory;
import com.pecpwee.lib.envmock.middle.location.LocationServiceFactory;
import com.pecpwee.lib.envmock.middle.telephony.TelephonyServiceFactory;
import com.pecpwee.lib.envmock.middle.wifi.WifiServiceFactory;
import com.pecpwee.lib.envmock.utils.ThreadManager;
import java.util.ArrayList;

public class EnvMockInstaller {
    public static boolean isPlayServiceInstalled = false;
    public static boolean isRecordServiceInstalled = false;

    public static synchronized boolean installPlayService(PlayConfig config) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        PlayConfig.setInstance(config);
        EnvMockInstaller.ensureCenterServiceInstalled(config.getContext());
        ThreadManager.PLAY_LOOPER = config.getLooper();
        ThreadManager.PLAY_HANDLER = new Handler(ThreadManager.PLAY_LOOPER);
        isPlayServiceInstalled = true;
        return true;
    }

    public static synchronized boolean installRecordService(RecordConfig config) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        RecordConfig.setConfigInstance(config);
        EnvMockInstaller.ensureCenterServiceInstalled(config.getContext());
        ThreadManager.RECORD_LOOPER = config.getLooper();
        ThreadManager.RECORD_HANDLER = new Handler(config.getLooper());
        isRecordServiceInstalled = true;
        return true;
    }

    private static void ensureCenterServiceInstalled(Context context) {
        if (isPlayServiceInstalled || isRecordServiceInstalled) {
            return;
        }
        ThreadManager.MAIN_LOOPER = context.getMainLooper();
        ThreadManager.MAIN_HANDLER = new Handler(context.getMainLooper());
        CenterServiceManager.init(context);
        ArrayList<AbsServiceFetcher> serviceList = new ArrayList<AbsServiceFetcher>();
        serviceList.add(new WifiServiceFactory(context));
        serviceList.add(new LocationServiceFactory(context));
        serviceList.add(new TelephonyServiceFactory(context));
        serviceList.add(new ConnectivityServiceFactory(context));
        for (AbsServiceFetcher serviceFactory : serviceList) {
            serviceFactory.install();
        }
    }
}

