/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.recorder.connect;

import android.annotation.TargetApi;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import com.pecpwee.lib.envmock.AbsConfig;
import com.pecpwee.lib.envmock.RecordConfig;
import com.pecpwee.lib.envmock.hook.CenterServiceManager;
import com.pecpwee.lib.envmock.model.connect.GetActiveNetwork;
import com.pecpwee.lib.envmock.model.connect.GetAllNetworks;
import com.pecpwee.lib.envmock.recorder.AbsRecorder;
import com.pecpwee.lib.envmock.utils.TimerJob;

public class ConnRecorder
extends AbsRecorder {
    private ConnectivityManager connectivityManager = (ConnectivityManager)CenterServiceManager.getInstance().getServiceFetcher("connectivity").getOrigManagerObj();
    private TimerJob connTimerJob = new TimerJob().setInterval(RecordConfig.getInstance().getSampleInterval()).setRunnable(new Runnable(){

        @Override
        public void run() {
            Network activeNetwork = null;
            if (Build.VERSION.SDK_INT >= 23) {
                activeNetwork = ConnRecorder.this.connectivityManager.getActiveNetwork();
            }
            ConnRecorder.this.doRecord(new GetActiveNetwork(activeNetwork, ConnRecorder.this.connectivityManager.getActiveNetworkInfo()));
            if (Build.VERSION.SDK_INT >= 21) {
                Network[] networks = ConnRecorder.this.connectivityManager.getAllNetworks();
                NetworkInfo[] networkinfos = ConnRecorder.this.getNetworkInfoArray(networks);
                NetworkCapabilities[] capacities = ConnRecorder.this.getNetworkCapabilitiesArray(networks);
                ConnRecorder.this.doRecord(new GetAllNetworks(networks, networkinfos, capacities));
            }
        }
    });

    @TargetApi(value=21)
    public NetworkCapabilities[] getNetworkCapabilitiesArray(Network[] networks) {
        NetworkCapabilities[] results = new NetworkCapabilities[networks.length];
        for (int i = 0; i < networks.length; ++i) {
            results[i] = this.connectivityManager.getNetworkCapabilities(networks[i]);
        }
        return results;
    }

    @TargetApi(value=21)
    public NetworkInfo[] getNetworkInfoArray(Network[] networks) {
        NetworkInfo[] results = new NetworkInfo[networks.length];
        for (int i = 0; i < networks.length; ++i) {
            results[i] = this.connectivityManager.getNetworkInfo(networks[i]);
        }
        return results;
    }

    @Override
    public void onStart() {
        this.connTimerJob.setInterval(RecordConfig.getInstance().getSampleInterval());
        this.connTimerJob.start();
    }

    @Override
    public void onStop() {
        this.connTimerJob.stop();
    }

    @Override
    public String getDefaultFilePath() {
        return AbsConfig.DEFAULT_FILEPATH_CONN;
    }
}

