/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.player;

import android.location.Location;
import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.hook.AbsServiceFetcher;
import com.pecpwee.lib.envmock.hook.CenterServiceManager;
import com.pecpwee.lib.envmock.player.AbsPlayer;
import com.pecpwee.lib.envmock.player.location.GpsPlayer;
import com.pecpwee.lib.envmock.utils.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class PlayerManager {
    public static void doStartPlay() {
        long time = System.currentTimeMillis();
        AbsPlayer player = null;
        Set<String> ServiceNameSet = PlayConfig.getInstance().getModuleStateMap().keySet();
        for (String sName : ServiceNameSet) {
            if (!PlayConfig.getInstance().getModuleStateMap().get((Object)sName).isPlayEnable) continue;
            player = CenterServiceManager.getInstance().getServiceFetcher(sName).getPlayer();
            player.startPlay(time);
        }
    }

    public static void doStopPlay() {
        Collection<AbsServiceFetcher> fetchers = CenterServiceManager.getInstance().getInstalledServiceCollection();
        for (AbsServiceFetcher fetcher : fetchers) {
            fetcher.getPlayer().stopPlay();
        }
        PlayerManager.resetLastPlayLocation();
    }

    public static synchronized float getPlayingProgress() {
        GpsPlayer gpsPlayer = (GpsPlayer)CenterServiceManager.getInstance().getServiceFetcher("location").getPlayer();
        if (gpsPlayer == null) {
            throw new RuntimeException("GPS Player module not enable");
        }
        return gpsPlayer.getCurrentPlayProgress();
    }

    public static synchronized List<Location> getCompletePlayPathLocations() {
        GpsPlayer gpsPlayer = (GpsPlayer)CenterServiceManager.getInstance().getServiceFetcher("location").getPlayer();
        if (gpsPlayer == null) {
            throw new RuntimeException("GPS Player module not enable");
        }
        gpsPlayer.tryLoadData();
        return gpsPlayer.getCompleteGpsPathLocation();
    }

    public static synchronized void resetLastPlayLocation() {
        GpsPlayer gpsPlayer = (GpsPlayer)CenterServiceManager.getInstance().getServiceFetcher("location").getPlayer();
        gpsPlayer.resetLastPlayedLocation();
    }

    public static synchronized Location getLastPlayLocation() {
        LogUtils.d("getLastPlayLocation");
        GpsPlayer gpsPlayer = (GpsPlayer)CenterServiceManager.getInstance().getServiceFetcher("location").getPlayer();
        Location location = gpsPlayer.getLastPlayedLocation();
        return location;
    }
}

