/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.middle.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.os.Bundle;
import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.middle.IMiddleService;
import com.pecpwee.lib.envmock.middle.location.IGpsPlayerListener;
import com.pecpwee.lib.envmock.middle.location.LM.ListenerTransportWrapper;
import com.pecpwee.lib.envmock.middle.location.LM.LocationRequestWrapper;
import com.pecpwee.lib.envmock.middle.location.LM.RequestLocationWrapper;
import com.pecpwee.lib.envmock.player.PlayerManager;
import com.pecpwee.lib.envmock.utils.LogUtils;
import java.util.ArrayList;

public abstract class AbsMiddleLocationManagerService
implements IGpsPlayerListener,
IMiddleService {
    private static final String TAG = "AbsMiddleLocationManagerService ";
    private ArrayList<RequestLocationWrapper> mRequestLocationList = new ArrayList();
    private LocationManager contextCachedCachedLocationService;

    public synchronized LocationManager getOrigLocationManager(Context context) {
        if (this.contextCachedCachedLocationService == null) {
            this.contextCachedCachedLocationService = (LocationManager)context.getSystemService("location");
        }
        return this.contextCachedCachedLocationService;
    }

    public final synchronized void requestLocationUpdates(Object LocationRequest, Object ILocationListener, PendingIntent pendingintent, String packageName) {
        LocationRequestWrapper locationRequestWrapper = new LocationRequestWrapper(LocationRequest);
        ListenerTransportWrapper listenerTransportWrapper = new ListenerTransportWrapper(ILocationListener);
        RequestLocationWrapper requestLocationWrapper = new RequestLocationWrapper(locationRequestWrapper, listenerTransportWrapper);
        this.mRequestLocationList.remove(requestLocationWrapper);
        this.mRequestLocationList.add(requestLocationWrapper);
        LogUtils.d("AbsMiddleLocationManagerService requestLocationUpdates");
        if (this.mRequestLocationList.size() == 1 && PlayConfig.getInstance().isAutoPlayMode()) {
            PlayerManager.doStartPlay();
        }
    }

    public final synchronized void removeUpdates(Object ILocationListener, PendingIntent intent, String packageName) {
        ListenerTransportWrapper listenerTransportWrapper = new ListenerTransportWrapper(ILocationListener);
        RequestLocationWrapper requestLocationWrapper = new RequestLocationWrapper(null, listenerTransportWrapper);
        this.mRequestLocationList.remove(requestLocationWrapper);
        LogUtils.d("removeUpdates,now the size:" + this.mRequestLocationList.size());
        if (this.mRequestLocationList.size() == 0 && PlayConfig.getInstance().isAutoStopMode()) {
            PlayerManager.doStopPlay();
        }
    }

    @Override
    public final synchronized void onLocationChanged(final Location location) {
        for (RequestLocationWrapper requestLocationWrapper : this.mRequestLocationList) {
            LocationRequestWrapper locationRequestWrapper = requestLocationWrapper.getLocationRequestWrapper();
            final ListenerTransportWrapper listenerTransportWrapper = requestLocationWrapper.getListenerTransportWrapper();
            String providerName = locationRequestWrapper.getProvider();
            if ("gps".equals(location.getProvider())) {
                if (!"gps".equals(providerName) && !"passive".equals(providerName)) continue;
                listenerTransportWrapper.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        listenerTransportWrapper.getLocationListener().onLocationChanged(location);
                    }
                });
                continue;
            }
            if (!"network".equals(location.getProvider()) || !"network".equals(providerName) && !"passive".equals(providerName)) continue;
            listenerTransportWrapper.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    listenerTransportWrapper.getLocationListener().onLocationChanged(location);
                }
            });
        }
    }

    @Override
    public final synchronized void onStatusChanged(final String provider, final int status, final Bundle extras) {
        for (RequestLocationWrapper requestLocationWrapper : this.mRequestLocationList) {
            LocationRequestWrapper locationRequestWrapper = requestLocationWrapper.getLocationRequestWrapper();
            final ListenerTransportWrapper listenerTransportWrapper = requestLocationWrapper.getListenerTransportWrapper();
            String providerName = locationRequestWrapper.getProvider();
            if (!"network".equals(providerName) && !"passive".equals(providerName)) continue;
            listenerTransportWrapper.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    listenerTransportWrapper.getLocationListener().onStatusChanged(provider, status, extras);
                }
            });
        }
    }

    @Override
    public final synchronized void onProviderEnabled(final String provider) {
        for (RequestLocationWrapper requestLocationWrapper : this.mRequestLocationList) {
            final ListenerTransportWrapper listenerTransportWrapper = requestLocationWrapper.getListenerTransportWrapper();
            LocationRequestWrapper locationRequestWrapper = requestLocationWrapper.getLocationRequestWrapper();
            String providerName = locationRequestWrapper.getProvider();
            if (!"gps".equals(providerName) && !"passive".equals(providerName)) continue;
            listenerTransportWrapper.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    listenerTransportWrapper.getLocationListener().onProviderEnabled(provider);
                }
            });
        }
    }

    @Override
    public final synchronized void onProviderDisabled(final String provider) {
        for (RequestLocationWrapper requestLocationWrapper : this.mRequestLocationList) {
            final ListenerTransportWrapper listenerTransportWrapper = requestLocationWrapper.getListenerTransportWrapper();
            LocationRequestWrapper locationRequestWrapper = requestLocationWrapper.getLocationRequestWrapper();
            String providerName = locationRequestWrapper.getProvider();
            if (!"gps".equals(providerName) && !"passive".equals(providerName)) continue;
            listenerTransportWrapper.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    listenerTransportWrapper.getLocationListener().onProviderEnabled(provider);
                }
            });
        }
    }

    public boolean addGpsStatusListener(Object IGpsStatusListener2, String packageName) {
        throw new RuntimeException("method have not implement");
    }

    public void removeGpsStatusListener(Object GpsStatusListenerTransportWrapper) {
        throw new RuntimeException("method have not implement");
    }

    public boolean addGnssMeasurementsListener(Object IGnssMeasurementsListener, String packageName) {
        throw new RuntimeException("method have not implement");
    }

    public void removeGnssMeasurementsListener(Object IGnssMeasurementsListener) {
        throw new RuntimeException("method have not implement");
    }

    public boolean registerGnssStatusCallback(Object IGnssStatusListener2, String packageName) {
        throw new RuntimeException("method have not implement");
    }

    public void unregisterGnssStatusCallback(Object IGnssStatusListener2) {
        throw new RuntimeException("method have not implement");
    }

    @Override
    public void onFirstFix(int ttff) {
        throw new RuntimeException("method have not implement");
    }

    @Override
    public void onNmeaReceived(long timestamp, String nmea) {
        throw new RuntimeException("method have not implement");
    }

    @Override
    public void resetMockData() {
    }
}

