/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.middle.connect;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.IBinder;
import com.pecpwee.lib.envmock.hook.AbsServiceFetcher;
import com.pecpwee.lib.envmock.middle.connect.IConnectivityListener;
import com.pecpwee.lib.envmock.middle.connect.MiddleConnectivityManager;
import com.pecpwee.lib.envmock.player.AbsPlayer;
import com.pecpwee.lib.envmock.player.connect.ConnPlayer;
import com.pecpwee.lib.envmock.utils.LogUtils;
import com.pecpwee.lib.envmock.utils.reflect.MethodUtils;
import java.lang.reflect.InvocationTargetException;

public class ConnectivityServiceFactory
extends AbsServiceFetcher {
    public ConnectivityServiceFactory(Context context) {
        super(context);
    }

    @Override
    public Object createManagerObj(IBinder binder) {
        try {
            Class<?> lmsInterfaceStub = Class.forName(this.getServiceBinderFullName() + "$Stub");
            Object serviceInterface = MethodUtils.invokeStaticMethod(lmsInterfaceStub, "asInterface", binder);
            int paramLength = ConnectivityManager.class.getConstructors()[0].getParameterTypes().length;
            Object[] paramList = null;
            if (paramLength == 2) {
                paramList = new Object[]{this.context, serviceInterface};
            }
            ConnectivityManager connManager = MethodUtils.invokeConstructor(ConnectivityManager.class, paramList);
            return connManager;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            LogUtils.log(t);
        }
        return null;
    }

    @Override
    protected Object createMiddleManagerService() {
        return new MiddleConnectivityManager();
    }

    @Override
    protected AbsPlayer createPlayer() {
        return new ConnPlayer((IConnectivityListener)this.getMiddleManagerService());
    }

    @Override
    public String getServiceName() {
        return "connectivity";
    }

    @Override
    public String getServiceBinderFullName() {
        return "android.net.IConnectivityManager";
    }
}

