/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envmock.hook;

import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.hook.CenterServiceManager;
import com.pecpwee.lib.envmock.hook.InvocationListenerProvider;
import com.pecpwee.lib.envmock.utils.LogUtils;
import com.pecpwee.lib.envmock.utils.reflect.MethodUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MiddleServiceBinder
implements InvocationHandler,
InvocationListenerProvider {
    protected Object origBinder;
    private List<InvocationListenerProvider.InvocationListener> mListenerList = new ArrayList<InvocationListenerProvider.InvocationListener>();
    private String mServiceName = null;
    protected Object middleManagerService = null;

    public MiddleServiceBinder(Object origBinder, String serviceName) {
        this.origBinder = origBinder;
        this.mServiceName = serviceName;
        this.middleManagerService = CenterServiceManager.getInstance().getServiceFetcher(this.mServiceName).getMiddleManagerService();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InvokeReturnObj invokeReturnObj;
        for (InvocationListenerProvider.InvocationListener listener : this.mListenerList) {
            listener.onMethodInvoke(proxy, method, args);
        }
        if (PlayConfig.getInstance().getModuleStateMap().get((Object)this.mServiceName).isHookEnable && (invokeReturnObj = this.invokeMiddleService(method, args)).hasInvoked) {
            return invokeReturnObj.returnObj;
        }
        return method.invoke(this.origBinder, args);
    }

    private InvokeReturnObj invokeMiddleService(Method method, Object[] args) {
        try {
            Object object = MethodUtils.invokeMethod(this.middleManagerService, method.getName(), args);
            LogUtils.d("method:" + method.getName() + " success");
            return new InvokeReturnObj(true, object);
        }
        catch (NoSuchMethodException e) {
            LogUtils.d("method:" + method.getName() + " not found");
        }
        catch (IllegalArgumentException e) {
            LogUtils.d("method:" + method.getName() + " argument error");
        }
        catch (Throwable t) {
            LogUtils.log(t);
        }
        return new InvokeReturnObj(false, null);
    }

    @Override
    public final void addListener(InvocationListenerProvider.InvocationListener listener) {
        this.mListenerList.add(listener);
    }

    @Override
    public final void removeListener(InvocationListenerProvider.InvocationListener listener) {
        this.mListenerList.remove(listener);
    }

    @Override
    public void clearListener() {
        this.mListenerList.clear();
    }

    protected static class InvokeReturnObj {
        private boolean hasInvoked;
        private Object returnObj;

        public InvokeReturnObj(boolean hasInvoked, Object returnObj) {
            this.hasInvoked = hasInvoked;
            this.returnObj = returnObj;
        }
    }
}

