/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock.middle.wifi;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.IBinder;
import com.pecpwee.lib.envMock.hook.AbsServiceFetcher;
import com.pecpwee.lib.envMock.middle.wifi.IWifiManager;
import com.pecpwee.lib.envMock.middle.wifi.IWifiPlayerListener;
import com.pecpwee.lib.envMock.middle.wifi.MiddleWifiManagerService;
import com.pecpwee.lib.envMock.player.AbsPlayer;
import com.pecpwee.lib.envMock.player.wifi.WifiPlayer;
import com.pecpwee.lib.envMock.utils.LogUtils;
import com.pecpwee.lib.envMock.utils.reflect.MethodUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;

public class WifiServiceFactory
extends AbsServiceFetcher {
    public WifiServiceFactory(Context context) {
        super(context);
    }

    @Override
    public String getServiceName() {
        return "wifi";
    }

    @Override
    public String getServiceBinderFullName() {
        return "android.net.wifi.IWifiManager";
    }

    @Override
    public Object createMiddleManagerService() {
        return new MiddleWifiManagerService();
    }

    @Override
    public Object createManagerObj(IBinder binder) {
        try {
            WifiManager wifiManager;
            Class<?> lmsInterfaceStub = Class.forName(this.getServiceBinderFullName() + "$Stub");
            Object serviceInterface = MethodUtils.invokeStaticMethod(lmsInterfaceStub, "asInterface", binder);
            int paramLength = WifiManager.class.getConstructors()[0].getParameterTypes().length;
            Object[] paramList = null;
            if (paramLength == 2) {
                paramList = new Object[]{this.context, serviceInterface};
            } else if (paramLength == 3) {
                paramList = new Object[]{this.context, serviceInterface, this.context.getMainLooper()};
            }
            WifiManager obj = wifiManager = MethodUtils.invokeConstructor(WifiManager.class, paramList);
            return obj;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            LogUtils.log(t);
        }
        return null;
    }

    @Override
    public InvocationHandler createProxyServiceBinder() {
        return new IWifiManager(this.getOrigBinderProxyObj());
    }

    @Override
    public AbsPlayer createPlayer() {
        WifiPlayer wifiPlayer = new WifiPlayer((IWifiPlayerListener)this.getMiddleManagerService());
        return wifiPlayer;
    }
}

