/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock.hook;

import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import com.pecpwee.lib.envMock.hook.CenterServiceManager;
import com.pecpwee.lib.envMock.hook.InvocationListenerProvider;
import com.pecpwee.lib.envMock.hook.ProxyServiceManagerDispatcherBinder;
import com.pecpwee.lib.envMock.player.AbsPlayer;
import com.pecpwee.lib.envMock.utils.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public abstract class AbsServiceFetcher {
    protected Context context;
    private IBinder mOrigServiceBinder;
    private IBinder mProxyServiceBinder;
    private Object mOrigManager;
    private Object mProxyManager;
    private Object mMiddleManagerService;
    private Object mInterfaceBinder;
    private AbsPlayer mPlayer;

    public AbsServiceFetcher(Context context) {
        this.context = context;
        this.getOrigServiceBinder();
    }

    public final IBinder getOrigServiceBinder() {
        if (this.mOrigServiceBinder == null) {
            this.mOrigServiceBinder = this.createOrigBinderByServiceName();
        }
        return this.mOrigServiceBinder;
    }

    public final Object getOrigBinderProxyObj() {
        if (this.mInterfaceBinder == null) {
            this.mInterfaceBinder = this.createOrigBinderInterfaceObj();
        }
        return this.mInterfaceBinder;
    }

    private Object createOrigBinderInterfaceObj() {
        Class stubClass = this.getServiceInterfaceStubClass();
        try {
            Method asInterfaceMethod = null;
            asInterfaceMethod = stubClass.getDeclaredMethod("asInterface", IBinder.class);
            return asInterfaceMethod.invoke(null, this.getOrigServiceBinder());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public final Object getOrigManagerObj() {
        if (this.mOrigManager == null) {
            this.mOrigManager = this.createManagerObj(this.getOrigServiceBinder());
        }
        return this.mOrigManager;
    }

    public final Object getProxyManagerObj() {
        if (this.mProxyManager == null) {
            this.mProxyManager = this.createManagerObj(this.getProxyServiceBinder());
        }
        return this.mProxyManager;
    }

    public final Object getMiddleManagerService() {
        if (this.mMiddleManagerService == null) {
            this.mMiddleManagerService = this.createMiddleManagerService();
        }
        return this.mMiddleManagerService;
    }

    public final IBinder getProxyServiceBinder() {
        if (this.mProxyServiceBinder == null) {
            this.mProxyServiceBinder = (IBinder)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IBinder.class, IInterface.class, this.getServiceInterfaceClass(), InvocationListenerProvider.class}, this.createProxyServiceBinder());
        }
        return this.mProxyServiceBinder;
    }

    public final AbsPlayer getPlayer() {
        if (this.mPlayer == null) {
            this.mPlayer = this.createPlayer();
        }
        return this.mPlayer;
    }

    private IBinder createOrigBinderByServiceName() {
        Class<?> serviceManager = null;
        try {
            serviceManager = Class.forName("android.os.ServiceManager");
            Method getService = serviceManager.getDeclaredMethod("getService", String.class);
            IBinder rawBinder = (IBinder)getService.invoke(null, this.getServiceName());
            return rawBinder;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public abstract Object createManagerObj(IBinder var1);

    public abstract InvocationHandler createProxyServiceBinder();

    public void install() {
        this.installOnCenterServiceManager();
        this.installOnSysServiceManager();
    }

    protected Class getServiceInterfaceClass() {
        try {
            return Class.forName(this.getServiceBinderFullName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Class getServiceInterfaceStubClass() {
        try {
            return Class.forName(this.getServiceBinderFullName() + "$Stub");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void installOnCenterServiceManager() {
        CenterServiceManager.getInstance().addService(this.getServiceName(), this);
    }

    private void installOnSysServiceManager() {
        IBinder dispatcherBinder = (IBinder)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IBinder.class}, (InvocationHandler)new ProxyServiceManagerDispatcherBinder(this.getServiceName()));
        try {
            Class<?> serviceManager = Class.forName("android.os.ServiceManager");
            Field cacheField = serviceManager.getDeclaredField("sCache");
            cacheField.setAccessible(true);
            Map cache = (Map)cacheField.get(null);
            cache.put(this.getServiceName(), dispatcherBinder);
        }
        catch (Throwable t) {
            LogUtils.log(t);
        }
    }

    protected abstract Object createMiddleManagerService();

    protected abstract AbsPlayer createPlayer();

    public abstract String getServiceName();

    public abstract String getServiceBinderFullName();
}

