/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock.recorder.telephony;

import android.content.Context;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import com.pecpwee.lib.envMock.AbsConfig;
import com.pecpwee.lib.envMock.RecordConfig;
import com.pecpwee.lib.envMock.hook.CenterServiceManager;
import com.pecpwee.lib.envMock.model.telephony.GetCellLocation;
import com.pecpwee.lib.envMock.model.telephony.GetNetworkType;
import com.pecpwee.lib.envMock.recorder.AbsRecorder;
import com.pecpwee.lib.envMock.utils.TimerJob;
import com.pecpwee.lib.envMock.utils.reflect.MethodUtils;
import java.lang.reflect.InvocationTargetException;

public class TelephonyRecorder
extends AbsRecorder {
    private TimerJob cellTimedJob = new TimerJob();
    private Context context;

    public TelephonyRecorder(Context context) {
        this.context = context;
        final TelephonyManager telephonyManager = (TelephonyManager)CenterServiceManager.getInstance().getServiceFetcher("phone").getOrigManagerObj();
        this.cellTimedJob.setInterval(RecordConfig.getInstance().getSampleInterval()).setRunnable(new Runnable(){

            @Override
            public void run() {
                Bundle bundle = TelephonyRecorder.this.getCellLocation();
                TelephonyRecorder.this.doRecord(new GetCellLocation(bundle));
                TelephonyRecorder.this.doRecord(new GetNetworkType(telephonyManager.getNetworkType()));
            }
        });
    }

    public Bundle getCellLocation() {
        Object origInterfaceBinderObj = CenterServiceManager.getInstance().getServiceFetcher("phone").getOrigBinderProxyObj();
        Bundle bundle = null;
        try {
            bundle = (Bundle)MethodUtils.invokeMethod(origInterfaceBinderObj, "getCellLocation", this.context.getPackageName());
        }
        catch (NoSuchMethodException e) {
            try {
                bundle = (Bundle)MethodUtils.invokeMethod(origInterfaceBinderObj, "getCellLocation", new Object[0]);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return bundle;
    }

    @Override
    public void onStart() {
        this.cellTimedJob.setInterval(RecordConfig.getInstance().getSampleInterval());
        this.cellTimedJob.start();
    }

    @Override
    public void onStop() {
        this.cellTimedJob.stop();
    }

    @Override
    public String getDefaultFilePath() {
        return AbsConfig.DEFAULT_FILEPATH_CELL;
    }
}

