/*
 * Decompiled with CFR 0.152.
 */
package com.pecpwee.lib.envMock.player;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.pecpwee.lib.envMock.PlayConfig;
import com.pecpwee.lib.envMock.utils.LogUtils;
import com.pecpwee.lib.envMock.utils.ThreadManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public abstract class AbsPlayer<T> {
    private static final String TAG = "AbsPlayer ";
    protected T mListener;
    private static final int HANDLER_DO_PLAY = 1;
    private ArrayList<TimedRunnable> mTimedActionsList;
    private int mCurrentTimedActionIndex = 0;
    private volatile boolean isNeedNextAction = false;
    private float mStartPlayOffset = 0.0f;
    private long mCurrentStartTime;
    private long mFileRecordStartTime;
    private long mFileRecordStopTime;
    private long mAcutalStartPastTimestamp;
    private CountDownLatch latchLock = null;
    private boolean isNeedReloadData = true;
    private Handler workHandler = new Handler(ThreadManager.PLAY_LOOPER);
    private Handler mainHandler = new Handler(ThreadManager.MAIN_LOOPER){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AbsPlayer.this.doAction();
                    AbsPlayer.this.scheduleAction(AbsPlayer.this.mCurrentTimedActionIndex + 1);
                    AbsPlayer.this.mCurrentTimedActionIndex++;
                }
            }
        }
    };

    public final void setListener(T listener) {
        this.mListener = listener;
    }

    public AbsPlayer(T listener) {
        this.mTimedActionsList = new ArrayList();
        this.mListener = listener;
    }

    protected void addTimedAction(TimedRunnable timeRunnable) {
        this.mTimedActionsList.add(timeRunnable);
    }

    public final synchronized void startPlay(long startBaseTime) {
        this.isNeedNextAction = true;
        this.mCurrentStartTime = startBaseTime;
        this.mStartPlayOffset = PlayConfig.getInstance().getStartPlayPercentage();
        this.latchLock = new CountDownLatch(1);
        this.workHandler.post(new Runnable(){

            @Override
            public void run() {
                AbsPlayer.this.loadDataIfNeed();
                AbsPlayer.this.dealWithPlayOffset();
                AbsPlayer.this.scheduleAction(AbsPlayer.this.mCurrentTimedActionIndex);
                AbsPlayer.this.latchLock.countDown();
            }
        });
        LogUtils.d(this.getClass().getSimpleName() + "doStartPlay");
    }

    public abstract String getDefaultFilePath();

    public abstract String getConfigFilePath();

    private synchronized void doAction() {
        LogUtils.d(TAG + this.getDefaultFilePath() + "doAction");
        if (this.mCurrentTimedActionIndex >= this.mTimedActionsList.size()) {
            this.stopPlay();
            return;
        }
        Runnable action = this.mTimedActionsList.get(this.mCurrentTimedActionIndex);
        this.mainHandler.post(action);
    }

    private void scheduleAction(int actionIndex) {
        if (!this.isNeedNextAction) {
            return;
        }
        if (actionIndex >= this.mTimedActionsList.size()) {
            return;
        }
        long nextOnePastTime = this.mTimedActionsList.get(actionIndex).getTime();
        long intervalTime = nextOnePastTime - this.mAcutalStartPastTimestamp + this.mCurrentStartTime - System.currentTimeMillis();
        intervalTime = intervalTime < 0L ? 0L : intervalTime;
        LogUtils.d(TAG + this.getDefaultFilePath() + " intervalTime " + intervalTime);
        this.mainHandler.sendEmptyMessageDelayed(1, intervalTime);
    }

    protected abstract ILineDataParser getParser();

    public synchronized void loadDataIfNeed() {
        if (!this.isNeedReloadData) {
            return;
        }
        this.mTimedActionsList.clear();
        String configFilePath = this.getConfigFilePath();
        if (!TextUtils.isEmpty((CharSequence)configFilePath)) {
            this.doLoadData(configFilePath);
        } else {
            this.doLoadData(this.getDefaultFilePath());
        }
        this.isNeedReloadData = false;
    }

    private void dealWithPlayOffset() {
        long recordTimeInterval = this.mFileRecordStopTime - this.mFileRecordStartTime;
        LogUtils.d("mFileRecordStartTime" + this.mFileRecordStartTime);
        LogUtils.d("mFileRecordStopTime" + this.mFileRecordStopTime);
        LogUtils.d("recordTimeInterval" + recordTimeInterval);
        long startOffsetTime = (long)((float)recordTimeInterval * this.mStartPlayOffset);
        LogUtils.d("startOffsetTime" + startOffsetTime);
        for (int i = 0; i < this.mTimedActionsList.size(); ++i) {
            if (this.mTimedActionsList.get(i).getTime() - this.mFileRecordStartTime <= startOffsetTime) continue;
            this.mCurrentTimedActionIndex = i;
            LogUtils.d("mCurrentTimedActionIndex" + this.mCurrentTimedActionIndex);
            this.mAcutalStartPastTimestamp = this.mTimedActionsList.get(i).getTime();
            LogUtils.d("mAcutalStartPastTimestamp" + this.mAcutalStartPastTimestamp);
            break;
        }
    }

    private synchronized void doLoadData(String path) {
        this.doLoadData(new File(path));
    }

    private synchronized void doLoadData(File file) {
        ILineDataParser parser = this.getParser();
        FileInputStream fis = null;
        if (!file.exists()) {
            throw new RuntimeException("cannot find mock data file");
        }
        this.mTimedActionsList.clear();
        LogUtils.d(this.getClass().getSimpleName() + "loading data from" + file.getAbsolutePath());
        try {
            int linecount = 0;
            fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = br.readLine()) != null) {
                parser.onNewLineGot(line);
                ++linecount;
            }
            br.close();
            LogUtils.d(this.getClass().getSimpleName() + "parsed the count of the line is:" + linecount);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void notifyDataSourceChanged() {
        this.isNeedReloadData = true;
    }

    public final synchronized void resetPlayProgress() {
        this.mCurrentTimedActionIndex = 0;
    }

    public final synchronized void stopPlay() {
        if (this.latchLock != null) {
            try {
                this.latchLock.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.isNeedNextAction = false;
        this.mainHandler.removeMessages(1);
        LogUtils.d(this.getClass().getSimpleName() + "doStopPlay");
    }

    public abstract class AbsParser
    implements ILineDataParser {
        private int type;
        private boolean isNeedParsingType = true;

        @Override
        public void onNewLineGot(String line) {
            if (this.isNeedParsingType) {
                this.type = this.parseType(line);
                this.isNeedParsingType = false;
            } else {
                if (this.type == -1) {
                    long time = 0L;
                    time = Long.parseLong(line);
                    AbsPlayer.this.mFileRecordStartTime = time;
                    AbsPlayer.this.mAcutalStartPastTimestamp = time;
                } else if (this.type == -2) {
                    long time = 0L;
                    time = Long.parseLong(line);
                    AbsPlayer.this.mFileRecordStopTime = time;
                } else {
                    this.parseValue(this.type, line);
                }
                this.isNeedParsingType = true;
            }
        }

        protected int parseType(String line) {
            return Integer.valueOf(line);
        }

        protected abstract void parseValue(int var1, String var2);
    }

    public static abstract class TimedRunnable
    implements Runnable {
        long time = 0L;

        public TimedRunnable(long time) {
            this.time = time;
        }

        @Override
        public abstract void run();

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }

    public static interface ILineDataParser {
        public void onNewLineGot(String var1);
    }
}

