/*
 * Decompiled with CFR 0.152.
 */
package com.peanut.sdk.updater;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.FileProvider;
import android.util.Log;
import com.peanut.sdk.updater.Channel;
import com.peanut.sdk.updater.DownloadBroadcast;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

public class Updater {
    private Handler handler;
    private String apkName;
    private String versionName;
    private String log;
    private String repertory;
    private String authority;
    private Context context;
    private Activity activity;
    private Channel channel;
    private int versionCode;
    private int lastVersionCode;

    public Updater(Activity activity, Context context, int versionCode) {
        this.handler = new Handler(context.getMainLooper());
        this.versionCode = versionCode;
        this.context = context;
        this.activity = activity;
    }

    private void update$() {
        this.analysis(this.getJSON(this.repertory + this.channel.code + "/output.json"));
        if (this.hasUpdate()) {
            this.handler.post(() -> {
                AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
                builder.setTitle((CharSequence)("\u66f4\u65b0" + this.versionName)).setMessage((CharSequence)this.log).setPositiveButton((CharSequence)"\u66f4\u65b0", (dialog, which) -> this.downloadApk(this.repertory + this.channel.code + "/" + this.apkName)).setNegativeButton((CharSequence)"\u53d6\u6d88", null).setCancelable(false).show();
            });
        }
    }

    private boolean hasUpdate() {
        return this.lastVersionCode > this.versionCode;
    }

    private void analysis(String json) {
        try {
            JSONObject jsonObject = new JSONArray(json).getJSONObject(0);
            this.lastVersionCode = Integer.parseInt(jsonObject.getJSONObject("apkInfo").get("versionCode").toString());
            this.apkName = jsonObject.get("path").toString();
            this.log = jsonObject.get("properties").toString();
            this.versionName = jsonObject.getJSONObject("apkInfo").get("versionName").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getJSON(String url) {
        StringBuilder result = new StringBuilder();
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.connect();
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
                while ((line = bufferedReader.readLine()) != null) {
                    result.append(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private void installApk(File apkFile) {
        Log.v((String)"path", (String)apkFile.toString());
        Intent installApkIntent = new Intent();
        installApkIntent.setAction("android.intent.action.VIEW");
        installApkIntent.addCategory("android.intent.category.DEFAULT");
        installApkIntent.setFlags(0x10000000);
        Log.v((String)"package", (String)(this.context.getPackageName() + "\n" + apkFile));
        if (Build.VERSION.SDK_INT > 23) {
            if (Build.VERSION.SDK_INT >= 26 && !this.context.getPackageManager().canRequestPackageInstalls()) {
                ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.REQUEST_INSTALL_PACKAGES"}, (int)10010);
            }
            installApkIntent.setDataAndType(FileProvider.getUriForFile((Context)this.context, (String)this.authority, (File)apkFile), "application/vnd.android.package-archive");
            installApkIntent.addFlags(1);
        } else {
            installApkIntent.setDataAndType(Uri.fromFile((File)apkFile), "application/vnd.android.package-archive");
        }
        this.context.startActivity(installApkIntent);
    }

    private void downloadApk(String fileUri) {
        this.deleteDirWithFile(this.context.getExternalFilesDir("Download"));
        String md5 = Updater.md5();
        DownloadManager downloadManager = (DownloadManager)this.context.getSystemService("download");
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)fileUri));
        request.setNotificationVisibility(1);
        request.setDestinationInExternalFilesDir(this.context, "Download", "peanut_" + md5 + ".apk");
        assert (downloadManager != null);
        Long downloadId = downloadManager.enqueue(request);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE");
        intentFilter.addAction("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED");
        intentFilter.addAction("android.intent.action.VIEW_DOWNLOADS");
        DownloadBroadcast mDownloadBroadcast = new DownloadBroadcast(downloadId);
        mDownloadBroadcast.setOnDownloadFinishListener(() -> {
            this.installApk(new File(this.context.getExternalFilesDir("Download") + "/peanut_" + md5 + ".apk"));
            this.context.unregisterReceiver((BroadcastReceiver)mDownloadBroadcast);
        });
        this.context.registerReceiver((BroadcastReceiver)mDownloadBroadcast, intentFilter);
    }

    private static String md5() {
        char[] hexDigits = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            stringBuilder.append(hexDigits[(int)(Math.random() * 15.0)]);
        }
        return stringBuilder.toString();
    }

    private void deleteDirWithFile(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                file.delete();
                continue;
            }
            if (!file.isDirectory()) continue;
            this.deleteDirWithFile(file);
        }
    }

    public static class Builder {
        Activity activity;
        String repertory;
        String authority;
        Channel channel;
        int currentCode;

        public Builder(Activity activity) {
            this.activity = activity;
        }

        public Builder setRepertory(String repertory) {
            this.repertory = repertory;
            return this;
        }

        public Builder setChanel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setCurrentCode(int currentCode) {
            this.currentCode = currentCode;
            return this;
        }

        public Builder setAuthority(String authority) {
            this.authority = authority;
            return this;
        }

        public void check() {
            final Updater updater = new Updater(this.activity, (Context)this.activity, this.currentCode);
            updater.channel = this.channel;
            updater.repertory = this.repertory;
            updater.authority = this.authority;
            new Thread(){

                @Override
                public void run() {
                    updater.update$();
                }
            }.start();
        }
    }
}

