/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.GetEmiAmountAccordingToInterestApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuEmiAmountAccordingToInterest;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class GetEmiAmountAccordingToInterestTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    GetEmiAmountAccordingToInterestApiListener apiListener;

    public GetEmiAmountAccordingToInterestTask(GetEmiAmountAccordingToInterestApiListener apiListener) {
        this.apiListener = apiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(), payuConfig.getData());
            if (null != conn) {
                int i;
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject jsonResponse = new JSONObject(responseStringBuffer.toString());
                if (jsonResponse.has("msg")) {
                    postData.setResult(jsonResponse.getString("msg"));
                }
                if (jsonResponse.has("status") && jsonResponse.getInt("status") == 0) {
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                } else {
                    postData.setCode(0);
                    postData.setStatus("SUCCESS");
                }
                Iterator keys = jsonResponse.keys();
                HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>> emiResponse = new HashMap<String, HashMap<String, PayuEmiAmountAccordingToInterest>>();
                while (keys.hasNext()) {
                    String bankCode = ((String)keys.next()).toString();
                    JSONObject bankBasedResponse = new JSONObject(jsonResponse.getString(bankCode));
                    Iterator nestedKeys = bankBasedResponse.keys();
                    HashMap<String, PayuEmiAmountAccordingToInterest> emiResponsePerEMIMonthBasis = new HashMap<String, PayuEmiAmountAccordingToInterest>();
                    while (nestedKeys.hasNext()) {
                        String emiMonth = ((String)nestedKeys.next()).toString();
                        JSONObject emiBasedResponse = new JSONObject(bankBasedResponse.getString(emiMonth));
                        PayuEmiAmountAccordingToInterest payuEmiAmountAccordingToInterest = new PayuEmiAmountAccordingToInterest();
                        payuEmiAmountAccordingToInterest.setEmiBankInterest(PayuUtils.getStringValueFromJSON(emiBasedResponse, "emiBankInterest"));
                        payuEmiAmountAccordingToInterest.setBankRate(PayuUtils.getStringValueFromJSON(emiBasedResponse, "bankRate"));
                        payuEmiAmountAccordingToInterest.setBankCharge(PayuUtils.getStringValueFromJSON(emiBasedResponse, "bankCharge"));
                        payuEmiAmountAccordingToInterest.setAmount(PayuUtils.getStringValueFromJSON(emiBasedResponse, "amount"));
                        payuEmiAmountAccordingToInterest.setCardType(PayuUtils.getStringValueFromJSON(emiBasedResponse, "card_type"));
                        payuEmiAmountAccordingToInterest.setEmiValue(PayuUtils.getStringValueFromJSON(emiBasedResponse, "emi_value"));
                        payuEmiAmountAccordingToInterest.setEmiInterestPaid(PayuUtils.getStringValueFromJSON(emiBasedResponse, "emi_interest_paid"));
                        payuEmiAmountAccordingToInterest.setTenure(PayuUtils.getStringValueFromJSON(emiBasedResponse, "tenure"));
                        emiResponsePerEMIMonthBasis.put(emiMonth, payuEmiAmountAccordingToInterest);
                    }
                    emiResponse.put(bankCode, emiResponsePerEMIMonthBasis);
                }
                payuResponse.setPayuEmiAmountAccordingToInterest(emiResponse);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.apiListener.onGetEmiAmountAccordingToInterestApiResponse(payuResponse);
    }
}

