//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Tasks;

import android.os.AsyncTask;

import com.payu.india.Interfaces.DeleteCardApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;
import com.payu.india.Payu.PayuUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by franklin on 6/19/15.
 * Async task which takes care of deleting a card
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 * Activity which calls {@link DeleteCardTask } should implement {@link DeleteCardApiListener}
 */
public class DeleteCardTask extends AsyncTask<PayuConfig, String, PayuResponse> {

    DeleteCardApiListener mDeleteCardApiListener;
    PayuConfig mPayuConfig;
    PayuResponse mPayuResponse;

    public DeleteCardTask(DeleteCardApiListener deleteCardApiListener) {
        this.mDeleteCardApiListener = deleteCardApiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        mPayuConfig = params[0];
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }


            HttpsURLConnection conn = PayuUtils.getHttpsConn(url.toString(),payuConfig.getData());
            if(null!=conn) {

                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }

                JSONObject response = new JSONObject(responseStringBuffer.toString());

                if (response.has(PayuConstants.MSG)) {
                    postData.setResult(response.getString(PayuConstants.MSG));
                }
                if (response.has(PayuConstants.STATUS) && response.getInt(PayuConstants.STATUS) == 1) {
                    postData.setCode(PayuErrors.NO_ERROR);
                    postData.setStatus(PayuConstants.SUCCESS);
                } else {
                    postData.setCode(PayuErrors.DELETE_CARD_EXCEPTION);
                    postData.setStatus(PayuConstants.ERROR);
                }
            }

        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (JSONException e) {
            e.printStackTrace();
        }

        // gotta return payuResponse
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mPayuResponse = payuResponse;
        DeleteMerchantHashTask mDeleteMerchantHashTask = new DeleteMerchantHashTask();
        mDeleteMerchantHashTask.execute();
//        mDeleteCardApiListener.onDeleteCardApiResponse(payuResponse);
    }


    class DeleteMerchantHashTask extends AsyncTask<Void, Void, Void>{

        @Override
        protected Void doInBackground(Void... params) {

            // here we get the card token and user credentials from the payuconfig by regex matching

            String mCardToken = "";
            String patternText = "var2=([^&]*)";
            String searchString = mPayuConfig.getData();
            Pattern pattern = Pattern.compile(patternText);
            Matcher matcher = pattern.matcher(searchString);
            while (matcher.find()) {
                mCardToken = matcher.group(1);
            }
            String mUserCredentials = "";
            patternText = "var1=([^&]*)";
            searchString = mPayuConfig.getData();
            pattern = Pattern.compile(patternText);
            matcher = pattern.matcher(searchString);
            while (matcher.find()) {
                mUserCredentials = matcher.group(1);
            }

            // ones we get card token and usercredentials we call the interface method to delete card.

//            if(!mCardToken.equals("") && !mUserCredentials.equals("")) {
//                OneClickPaymentListener mOneTapCallBack = OnetapCallback.getOneTapCallback();
//                if(mOneTapCallBack != null)
//                    mOneTapCallBack.deleteOneClickHash(mCardToken, mUserCredentials);
//            }

            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
            mDeleteCardApiListener.onDeleteCardApiResponse(mPayuResponse);
        }
    }
}