//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by franklin on 7/3/15.
 * Simple bean implementation of payu offers.
 * should be used with {@link com.payu.india.Interfaces.GetOfferStatusApiListener}
 */
public class PayuOffer implements Parcelable {

    private String status;
    private String msg;
    private String errorCode;
    private String offerKey;
    private String offerType;
    private String offerAvailedCount;
    private String offerRemainingCount;
    private String discount;
    private String category;
    private ArrayList<String> allowedOn;

    protected PayuOffer(Parcel in) {
        status = in.readString();
        msg = in.readString();
        errorCode = in.readString();
        offerKey = in.readString();
        offerType = in.readString();
        offerAvailedCount = in.readString();
        offerRemainingCount = in.readString();
        discount = in.readString();
        category = in.readString();
        allowedOn = in.createStringArrayList();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(status);
        dest.writeString(msg);
        dest.writeString(errorCode);
        dest.writeString(offerKey);
        dest.writeString(offerType);
        dest.writeString(offerAvailedCount);
        dest.writeString(offerRemainingCount);
        dest.writeString(discount);
        dest.writeString(category);
        dest.writeStringList(allowedOn);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PayuOffer> CREATOR = new Creator<PayuOffer>() {
        @Override
        public PayuOffer createFromParcel(Parcel in) {
            return new PayuOffer(in);
        }

        @Override
        public PayuOffer[] newArray(int size) {
            return new PayuOffer[size];
        }
    };

    public ArrayList<String> getAllowedOn() {
        return allowedOn;
    }

    public void setAllowedOn(ArrayList<String> allowedOn) {
        this.allowedOn = allowedOn;
    }


    public PayuOffer() {
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getOfferKey() {
        return offerKey;
    }

    public void setOfferKey(String offerKey) {
        this.offerKey = offerKey;
    }

    public String getOfferType() {
        return offerType;
    }

    public void setOfferType(String offerType) {
        this.offerType = offerType;
    }

    public String getOfferAvailedCount() {
        return offerAvailedCount;
    }

    public void setOfferAvailedCount(String offerAvailedCount) {
        this.offerAvailedCount = offerAvailedCount;
    }

    public String getOfferRemainingCount() {
        return offerRemainingCount;
    }

    public void setOfferRemainingCount(String offerRemainingCount) {
        this.offerRemainingCount = offerRemainingCount;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}
