/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.PostParams;

import com.payu.india.Model.MerchantWebService;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuUtils;
import com.payu.paymentparamhelper.PostData;
import org.json.JSONException;
import org.json.JSONObject;

public class MerchantWebServicePostParams
extends PayuUtils {
    private MerchantWebService merchantWebService;
    private StringBuilder post;

    private MerchantWebServicePostParams() {
    }

    public MerchantWebServicePostParams(MerchantWebService merchantWebService) {
        this.merchantWebService = merchantWebService;
    }

    public PostData getMerchantWebServicePostParams() {
        this.post = new StringBuilder();
        int expiryMonth = 0;
        int expiryYear = 0;
        this.post.append(this.concatParams("udid", this.getUdid()));
        this.post.append(this.concatParams("imei", this.getImei()));
        this.post.append(this.concatParams("sdk_platform", PayuUtils.getAnalyticsString()));
        if (this.merchantWebService.getKey() == null) {
            return this.getReturnData("Mandatory param key is missing");
        }
        this.post.append(this.concatParams("key", this.merchantWebService.getKey()));
        if (this.merchantWebService.getHash() == null) {
            return this.getReturnData("Mandatory param hash is missing");
        }
        this.post.append(this.concatParams("hash", this.merchantWebService.getHash()));
        if (this.merchantWebService.getCommand() == null || !PayuConstants.COMMAND_SET.contains(this.merchantWebService.getCommand())) {
            return this.getReturnData("Mandatory param command is missing");
        }
        this.post.append(this.concatParams("command", this.merchantWebService.getCommand()));
        switch (this.merchantWebService.getCommand()) {
            case "payment_related_details_for_mobile_sdk": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1 should be user_credentials (merchant_key:unique_user_id.) to get the merchant information and stored card or default to get only the merchant information");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "vas_for_mobile_sdk": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1 Please send var1 as 'default'");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.merchantWebService.getVar2() == null ? this.concatParams("var2", "default") : this.concatParams("var2", this.merchantWebService.getVar2()));
                this.post.append(this.merchantWebService.getVar2() == null ? this.concatParams("var3", "default") : this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "get_merchant_ibibo_codes": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1 Please send var1 as 'default'");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "verify_payment": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Transaction id (txnid)if you want to verify more than one transaction please separate them by pipe : ex 6234567|45678987|4567876 ");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "check_payment": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "cancel_refund_transaction": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Token ID(unique token from merchant)");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing var3  should contain the amount which needs to be refunded. Please note that both partial and full refunds are allowed.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                this.post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "check_action_status": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Request ID which you get while cancel_refund_transaction api");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "capture_transaction": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing should be the Token ID(unique token from merchant)");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                break;
            }
            case "update_requests": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Request ID which you get while cancel_refund_transaction api");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing var3should be the Bank Ref Id for the requested transaction.");
                }
                if (this.merchantWebService.getVar4() == null) {
                    return this.getReturnData("Mandatory param var4 is missing var4 Amount should be a Double value example 5.00");
                }
                if (this.merchantWebService.getVar5() == null) {
                    return this.getReturnData("Mandatory param var5 is missing var5should be the Action (cancel/capture/refund)");
                }
                if (this.merchantWebService.getVar6() == null) {
                    return this.getReturnData("Mandatory param var6 is missing var6 should be new status to be set");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                this.post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                this.post.append(this.concatParams("var4", this.merchantWebService.getVar4()));
                this.post.append(this.concatParams("var5", this.merchantWebService.getVar5()));
                this.post.append(this.concatParams("var6", this.merchantWebService.getVar6()));
                break;
            }
            case "cod_verify": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Token ID(unique token from merchant)");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing var3 Amount should be a Double value example 5.00");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                this.post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "cod_cancel": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Token ID(unique token from merchant)");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing var3 Amount should be a Double value example 5.00");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                this.post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "cod_settled": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the Token ID(unique token from merchant)");
                }
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("5001 var3 Amount should be a Double value example 5.00");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                this.post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                break;
            }
            case "get_TDR": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Payu id (mihpayid) of the transaction which was given by payu.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "udf_update": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the Transaction id (txnid)");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.merchantWebService.getVar2() == null ? "" : this.concatParams("var2", this.merchantWebService.getVar2()));
                this.post.append(this.merchantWebService.getVar3() == null ? "" : this.concatParams("var3", this.merchantWebService.getVar3()));
                this.post.append(this.merchantWebService.getVar4() == null ? "" : this.concatParams("var4", this.merchantWebService.getVar4()));
                this.post.append(this.merchantWebService.getVar5() == null ? "" : this.concatParams("var5", this.merchantWebService.getVar5()));
                this.post.append(this.merchantWebService.getVar6() == null ? "" : this.concatParams("var6", this.merchantWebService.getVar6()));
            }
            case "create_invoice": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                try {
                    String[] invoiceMandatoryKeys;
                    JSONObject invoiceObject = new JSONObject(this.merchantWebService.getVar1());
                    block91: for (String key : invoiceMandatoryKeys = new String[]{"amount", "txnid", "productinfo", "firstname", "email", "phone"}) {
                        if (invoiceObject.getString(key) == null || invoiceObject.getString(key).length() < 1) {
                            return this.getReturnData("Mandatory param " + key + " is missing for creating an Invoice");
                        }
                        switch (key) {
                            case "amount": {
                                try {
                                    Double.parseDouble(invoiceObject.getString(key));
                                    continue block91;
                                }
                                catch (NumberFormatException e) {
                                    return this.getReturnData(5003, " Amount should be a Double value example 5.00");
                                }
                            }
                            case "txnid": {
                                continue block91;
                            }
                            case "productinfo": {
                                continue block91;
                            }
                            case "firstname": {
                                continue block91;
                            }
                            case "email": {
                                continue block91;
                            }
                        }
                    }
                    this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                    break;
                }
                catch (JSONException e) {
                    return this.getReturnData(5014, "var1  should be a stringified JSON object; It seems there is an exception while parsing JSON");
                }
            }
            case "check_offer_status": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1 should be offer key example : offer@1234 ");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2() == null ? "" : this.merchantWebService.getVar2()));
                this.post.append(this.concatParams("var3", this.merchantWebService.getVar3() == null ? "" : this.merchantWebService.getVar3()));
                this.post.append(this.concatParams("var4", this.merchantWebService.getVar4() == null ? "" : this.merchantWebService.getVar4()));
                this.post.append(this.concatParams("var5", this.merchantWebService.getVar5() == null ? "" : this.merchantWebService.getVar5()));
                this.post.append(this.concatParams("var6", this.merchantWebService.getVar6() == null ? "" : this.merchantWebService.getVar6()));
                this.post.append(this.concatParams("var7", this.merchantWebService.getVar7() == null ? "" : this.merchantWebService.getVar7()));
                this.post.append(this.concatParams("var8", this.merchantWebService.getVar8() == null ? "" : this.merchantWebService.getVar8()));
                this.post.append(this.concatParams("var9", this.merchantWebService.getVar9() == null ? "" : this.merchantWebService.getVar9()));
                this.post.append(this.concatParams("var10", this.merchantWebService.getVar10() == null ? "" : this.merchantWebService.getVar10()));
                this.post.append(this.concatParams("var11", this.merchantWebService.getVar11() == null ? "" : this.merchantWebService.getVar11()));
                break;
            }
            case "getNetbankingStatus": {
                if (this.merchantWebService.getVar1() == null || this.merchantWebService.getVar1().length() < 1) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the bank code for one bank, default for getting all banks");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "getIssuingBankStatus": {
                if (this.merchantWebService.getVar1() == null || this.merchantWebService.getVar1().length() != 6) {
                    return this.getReturnData("Mandatory param var1 is missing var1number or the card bin (first 6 digit of the card)");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "get_Transaction_Details": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the from date in YYYY-MM-DD format");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2till date in YYYY-MM-DD format.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                break;
            }
            case "get_transaction_info": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the from date in YYYY-MM-DD hh:mm:ss format");
                }
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the till date in YYYY-MM-DD hh:mm:ss format.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                break;
            }
            case "check_isDomestic": {
                if (this.merchantWebService.getVar1() == null || this.merchantWebService.getVar1().length() < 6) {
                    return this.getReturnData("Mandatory param var1 is missing var1number or the card bin (first 6 digit of the card)");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "get_user_cards": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "save_user_card": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() == null || this.merchantWebService.getVar2().length() < 1) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the card name (nickname of the card)");
                }
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                if (this.merchantWebService.getVar3() == null || !this.merchantWebService.getVar3().contentEquals("CC")) {
                    return this.getReturnData("Mandatory param var3 is missing var3should be the card mode; please use CC as card mode");
                }
                this.post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                if (this.merchantWebService.getVar4() == null || !this.merchantWebService.getVar4().contentEquals("CC")) {
                    return this.getReturnData("Mandatory param var4 is missing var4should be the card type; please use CC as card type");
                }
                this.post.append(this.concatParams("var4", this.merchantWebService.getVar4()));
                if (this.merchantWebService.getVar5() == null || this.merchantWebService.getVar5().length() < 1) {
                    return this.getReturnData("Mandatory param var5 is missing var5 should be name on card");
                }
                this.post.append(this.concatParams("var5", this.merchantWebService.getVar5()));
                if (this.merchantWebService.getVar6() == null || !this.validateCardNumber(this.merchantWebService.getVar6()).booleanValue()) {
                    return this.getReturnData("Mandatory param var6 is missing var6 should be a valid credit / debit card number");
                }
                this.post.append(this.concatParams("var6", this.merchantWebService.getVar6()));
                expiryMonth = 0;
                expiryYear = 0;
                try {
                    expiryMonth = Integer.parseInt(this.merchantWebService.getVar7());
                }
                catch (NumberFormatException e) {
                    return this.getReturnData(5002, " Invalid month, it should be two digit number range from 01 to 12 MM format");
                }
                try {
                    expiryYear = Integer.parseInt(this.merchantWebService.getVar8());
                }
                catch (NumberFormatException e) {
                    return this.getReturnData(5002, " Invalid year, year should be 4 digit YYYY format");
                }
                if (!this.validateExpiry(expiryMonth, expiryYear)) {
                    return this.getReturnData(5012, " It seems the card is expired!");
                }
                this.post.append(this.concatParams("var7", this.merchantWebService.getVar7()));
                this.post.append(this.concatParams("var8", this.merchantWebService.getVar8()));
                if (null == this.merchantWebService.getVar10() || this.merchantWebService.getVar10().length() <= 0) break;
                this.post.append(this.concatParams("var10", this.merchantWebService.getVar10()));
                break;
            }
            case "edit_user_card": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing var1should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() == null || this.merchantWebService.getVar2().length() < 1) {
                    return this.getReturnData("Mandatory param var2 is missing var2should be the card token, you get the card token when you store/fetch a card");
                }
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                if (this.merchantWebService.getVar3() == null || this.merchantWebService.getVar3().length() < 1) {
                    return this.getReturnData("Mandatory param var3 is missing var3should be the card name (nickname of the card)");
                }
                this.post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                this.post.append(this.concatParams("var4", this.merchantWebService.getVar4() == null ? "CC" : this.merchantWebService.getVar4()));
                this.post.append(this.concatParams("var5", this.merchantWebService.getVar5() == null ? "CC" : this.merchantWebService.getVar5()));
                if (this.merchantWebService.getVar6() == null || this.merchantWebService.getVar6().length() < 1) {
                    return this.getReturnData("Mandatory param var6 is missing var6 should be name on card");
                }
                this.post.append(this.concatParams("var6", this.merchantWebService.getVar6()));
                if (this.merchantWebService.getVar7() == null || !this.validateCardNumber(this.merchantWebService.getVar7()).booleanValue()) {
                    return this.getReturnData("Mandatory param var7 is missing var7 should be a valid credit / debit card number");
                }
                this.post.append(this.concatParams("var7", this.merchantWebService.getVar7()));
                expiryMonth = 0;
                expiryYear = 0;
                try {
                    expiryMonth = Integer.parseInt(this.merchantWebService.getVar8());
                }
                catch (NumberFormatException e) {
                    return this.getReturnData(5002, " Invalid month, it should be two digit number range from 01 to 12 MM format");
                }
                try {
                    expiryYear = Integer.parseInt(this.merchantWebService.getVar9());
                }
                catch (NumberFormatException e) {
                    return this.getReturnData(5002, " Invalid year, year should be 4 digit YYYY format");
                }
                if (this.validateExpiry(expiryMonth, expiryYear)) {
                    this.post.append(this.concatParams("var8", this.merchantWebService.getVar8()));
                    this.post.append(this.concatParams("var9", this.merchantWebService.getVar9()));
                    break;
                }
                return this.getReturnData(5012, " It seems the card is expired!");
            }
            case "delete_user_card": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() != null && this.merchantWebService.getVar2().length() > 2) {
                    this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                    break;
                }
                return this.getReturnData("Mandatory param var2 is missing var2should be the card token, you get the card token when you store/fetch a card");
            }
            case "delete_store_card_cvv": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing should be the user credentials and it should be merchant_key:unique_user_id.");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() != null && this.merchantWebService.getVar2().length() > 2) {
                    this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                    break;
                }
                return this.getReturnData("Mandatory param var2 is missing var2should be the card token, you get the card token when you store/fetch a card");
            }
            case "mobileHashTestWs": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "get_hashes": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                break;
            }
            case "check_offer_details": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
                if (this.merchantWebService.getVar2() == null) {
                    return this.getReturnData("Mandatory param var2 is missing");
                }
                this.post.append(this.concatParams("var2", this.merchantWebService.getVar2()));
                if (this.merchantWebService.getVar3() == null) {
                    return this.getReturnData("Mandatory param var3 is missing");
                }
                this.post.append(this.concatParams("var3", this.merchantWebService.getVar3()));
                this.post.append(this.concatParams("var4", this.merchantWebService.getVar4() == null ? "" : this.merchantWebService.getVar4()));
                this.post.append(this.concatParams("var5", this.merchantWebService.getVar5() == null ? "" : this.merchantWebService.getVar5()));
                break;
            }
            case "getEmiAmountAccordingToInterest": {
                if (this.merchantWebService.getVar1() == null) {
                    return this.getReturnData("Mandatory param var1 is missing");
                }
                this.post.append(this.concatParams("var1", this.merchantWebService.getVar1()));
            }
        }
        return this.getReturnData(0, "SUCCESS", this.trimAmpersand(this.post.toString()));
    }
}

