package com.payu.india.Tasks;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;

import com.payu.india.Payu.PayuConstants;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by Minie on 9/30/15.
 */
public class PayuUploadDeviceAnalytics {
    private static final String TEST_URL = "https://mobiletest.payu.in/merchant/mobileWebService.php";
    //private static final String TEST_URL = "https://mobiletest.payu.in/merchant/mobileWebService.php";
    private static final String PRODUCTION_URL = "https://info.payu.in/merchant/mobileWebService.php";
    private String fileName = "sdk_local_cache_device";
    private static long TIMER_DELAY = 0;
    private final Context appContext;
    private String ANALYTICS_URL = isProduction?PRODUCTION_URL:TEST_URL;
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer = new ArrayList<String>();
    private Timer mTimer;
    private static boolean isProduction=true;


    /**
     * Constructor
     * @param appContext
     */
    public PayuUploadDeviceAnalytics(Context appContext,String filename) {
        this.appContext = appContext;
        fileName=filename;
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (mIsLocked) ;
                setLock();
                try {
                    FileOutputStream fileOutputStream = PayuUploadDeviceAnalytics.this.appContext.openFileOutput(fileName, Context.MODE_PRIVATE);
                    int c = mBuffer.size();
                    for (int i = 0; i < c; i++) {
                        fileOutputStream.write((mBuffer.get(i) + "\r\n").getBytes());
                    }
                    fileOutputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    /**
     * Adding log information to a local file.
     * @param msg
     */
    public void log(final String msg) {

        if (mIsLocked) {
            mBuffer.add(msg);
        } else {
            /*new AsyncTask<Void, Void, Void>() {
                @Override
                protected Void doInBackground(Void... voids) {*/
                    setLock();
                    try {
                        JSONObject newobject = new JSONObject(msg);
                        JSONArray jsonArray=new JSONArray();
                        int c;
                        String temp = "";
                        File file = new File(appContext.getFilesDir(), fileName);
                        if (!file.exists()) { // create the file if not created yet.
                            appContext.openFileOutput(fileName, Context.MODE_PRIVATE);
                        }
                        FileInputStream fileInputStream = appContext.openFileInput(fileName);
                        while ((c = fileInputStream.read()) != -1) {
                            temp = temp + Character.toString((char) c);
                             jsonArray = new JSONArray(temp);

                        }
                        fileInputStream.close();
                        FileOutputStream fileOutputStream = appContext.openFileOutput(fileName, Context.MODE_PRIVATE);
                        jsonArray.put(jsonArray.length(),newobject);
                        fileOutputStream.write((temp + jsonArray.toString() + "\r\n").getBytes());
                        fileOutputStream.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                        mBuffer.add(msg);
                    }catch(JSONException e){
                        e.printStackTrace();
                    }
                    releaseLock();
                   // return null;
                }
        resetTimer();
            /*}.execute(null, null, null);*/
        }

    /**
     * Open file and read the content.
     * Send the contents to payu server
     * command should be sdkWs and var1 should be the actual data.
     */
    private void resetTimer() {
        if (mTimer != null) {
            mTimer.cancel();
        }
        mTimer = new Timer();
        mTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                while (mIsLocked) ;
                TIMER_DELAY = 5000;
                setLock();
                String temp = "";
                int c;
                try {
                    File file = new File(appContext.getFilesDir(), fileName);
                    if (!file.exists()) { // create the file if not created yet.
                        appContext.openFileOutput(fileName, Context.MODE_PRIVATE);
                    }
                    FileInputStream fileInputStream = appContext.openFileInput(fileName);
                    while ((c = fileInputStream.read()) != -1) {
                        temp = temp + Character.toString((char) c);

                    }
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    c = mBuffer.size();
                    while (c > 0) {
                        c--;
                        temp = temp + mBuffer.get(c) + "\r\n";
                        if (c >= 0 && mBuffer.size() > c)
                            mBuffer.remove(c);
                    }
                    temp = temp.trim();
                    if (temp.length() > 0) {
                        // lets prepare data

                        //put data here
                        new UploadData(temp).execute(temp);

                    }
                }
                if (mBuffer.size() > 0) {
                    resetTimer();
                }
                releaseLock();
            }
        }, TIMER_DELAY);
    }

    synchronized void setLock() {
        mIsLocked = true;
    }

    synchronized void releaseLock() {
        mIsLocked = false;
    }

    public boolean getbooleanSharedPreference(String key){
        SharedPreferences sharedPreferences= appContext.getSharedPreferences("com.payu", Context.MODE_PRIVATE);
        return sharedPreferences.getBoolean(key, false);
    }

    public void setBooleanSharedPreference(String key,boolean value){
        SharedPreferences.Editor editor= appContext.getSharedPreferences("com.payu", Context.MODE_PRIVATE).edit();
        editor.putBoolean(key,value);
        editor.apply();
    }

    public static JSONArray removeJsonObjectAtJsonArrayIndex(JSONArray source, int index) throws JSONException {
        if (index < 0 || index > source.length() - 1) {
            throw new IndexOutOfBoundsException();
        }

        final JSONArray copy = new JSONArray();
        for (int i = 0, count = source.length(); i < count; i++) {
            if (i != index) copy.put(source.get(i));
        }
        return copy;
    }

    public class UploadData extends AsyncTask<String,Void,String>{
        private String temp;
        UploadData(String temp){
            this.temp=temp;
        }
        @Override
        protected void onPostExecute(String aVoid) {
            super.onPostExecute(aVoid);
        }

        @Override
        protected String doInBackground(String... strarr) {
            try{
                try {
                  

                    JSONArray jsonArray=new JSONArray(strarr[0]);
                    JSONArray editorJsonArray=jsonArray;
                    for(int j=0;j<editorJsonArray.length();j++)
                    {

                        if(getbooleanSharedPreference(((JSONObject)editorJsonArray.get(j)).getString(PayuConstants.MERCHANT_KEY)+"|"+((JSONObject)editorJsonArray.get(j)).getString(PayuConstants.TRANSACTION_ID))){
                            jsonArray=removeJsonObjectAtJsonArrayIndex(editorJsonArray,j);

                        }
                    }
                    if(jsonArray.length()>0) {

                        String postData = "mobile_data="+jsonArray.toString();
                        byte[] postParamsByte = postData.getBytes("UTF-8");
                        URL url = new URL(ANALYTICS_URL);
                        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
                        conn.setDoOutput(true);
                        conn.getOutputStream().write(postParamsByte);
                        int responseCode = conn.getResponseCode();

                        InputStream responseInputStream = conn.getInputStream();
                        StringBuffer responseStringBuffer = new StringBuffer();
                        byte[] byteContainer = new byte[1024];
                        for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                            responseStringBuffer.append(new String(byteContainer, 0, i));
                        }
                        if (responseCode == HttpURLConnection.HTTP_OK) {
                            try {

                                JSONObject jsonObject=new JSONObject(responseStringBuffer.toString());
                                if (jsonObject.has("status") && !jsonObject.getString("status").equalsIgnoreCase("")) {
                                    appContext.deleteFile(fileName);
                                    if(jsonObject.has("status") && (jsonObject.getString("status").equalsIgnoreCase("1")||jsonObject.getString("status").equalsIgnoreCase("-1"))){
                                        for (int j = 0; j < jsonArray.length(); j++) {
                                            setBooleanSharedPreference(((JSONObject) jsonArray.get(j)).getString(PayuConstants.MERCHANT_KEY) + "|" + ((JSONObject) jsonArray.get(j)).getString(PayuConstants.TRANSACTION_ID), true);
                                        }
                                    }else{

                                        try {
                                            FileOutputStream fileOutputStream = appContext.openFileOutput(fileName, Context.MODE_PRIVATE);
                                            fileOutputStream.write(temp.getBytes());
                                            fileOutputStream.close();
                                        } catch (IOException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }else{
                                    try {
                                        FileOutputStream fileOutputStream = appContext.openFileOutput(fileName, Context.MODE_PRIVATE);
                                        fileOutputStream.write(temp.getBytes());
                                        fileOutputStream.close();
                                    } catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }

                            }catch(Exception e)
                            {
                                e.printStackTrace();
                                try {
                                    FileOutputStream fileOutputStream = appContext.openFileOutput(fileName, Context.MODE_PRIVATE);
                                    fileOutputStream.write(temp.getBytes());
                                    fileOutputStream.close();
                                } catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        } else {

                            try {
                                FileOutputStream fileOutputStream = appContext.openFileOutput(fileName, Context.MODE_PRIVATE);
                                fileOutputStream.write(temp.getBytes());
                                fileOutputStream.close();
                            } catch (IOException e1) {

                                e1.printStackTrace();
                            }
                        }
                    }else{

                        appContext.deleteFile(fileName);
                    }

                } catch (MalformedURLException | ProtocolException e) {
                    e.printStackTrace();

                } catch (IOException e) {
                    resetTimer();
                    e.printStackTrace();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
            return null;
        }
    }
}