package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.CheckOfferDetailsApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuOfferDetails;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PayuUserOffer;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/**
 * Created by franklin.michael on 08/03/16.
 * Async task which takes care of Getting all the offer details for one or more offer keys
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 * Activity which calls {@link CheckOfferDetailsTask} should implement {@link CheckOfferDetailsApiListener}
 */
public class CheckOfferDetailsTask extends AsyncTask<PayuConfig, String, PayuResponse> {

    CheckOfferDetailsApiListener mCheckOfferDetailsApiListener;

    public CheckOfferDetailsTask(CheckOfferDetailsApiListener checkOfferDetailsApiListener) {
        mCheckOfferDetailsApiListener = checkOfferDetailsApiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }

            byte[] postParamsByte = payuConfig.getData().getBytes("UTF-8");

            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postParamsByte.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postParamsByte);

            InputStream responseInputStream = conn.getInputStream();
            StringBuffer responseStringBuffer = new StringBuffer();
            byte[] byteContainer = new byte[1024];
            for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                responseStringBuffer.append(new String(byteContainer, 0, i));
            }

            JSONObject response = new JSONObject(responseStringBuffer.toString());

            PayuOfferDetails payuOfferDetails = new PayuOfferDetails(); // will have array list of payuUserOfferArray.
            if(response.has(PayuConstants.DATA_KEY)){
                // valid response
                ArrayList<PayuUserOffer> payuUserOfferArrayList = new ArrayList<>();

                if(response.get(PayuConstants.DATA_KEY).toString().contentEquals(PayuConstants.CARD_TOKENS)){ // dealing with card tokens.(applicable to one or more offer keys)
                    JSONObject cardTokensObject = response.getJSONObject(PayuConstants.CARD_TOKENS);
                    Iterator<String> cardTokenKeys = cardTokensObject.keys();
                    while (cardTokenKeys.hasNext()){  // one or more user card and each card has one or more offer details.
                        // json object which has one user card and one or more offer data.
                        // should be filled in payuUserOffer object.
                        JSONObject cardDataAndOfferObject = cardTokensObject.getJSONObject(cardTokenKeys.next());
                        JSONObject cardDataObject = cardDataAndOfferObject.getJSONObject(PayuConstants.CARD_DATA);
                        JSONObject offerDataObject = cardDataAndOfferObject.getJSONObject(PayuConstants.OFFER_DATA);
                        Iterator<String> cardDataKeys = cardDataObject.keys();
                        PayuUserOffer payuUserOffer = new PayuUserOffer();  // will have one card details and one or more offer details.
                        StoredCard storedCard = new StoredCard();
                        while(cardDataKeys.hasNext()){ // one user card and one or more offer.
                            switch (cardDataKeys.next()){
                                case PayuConstants.NAME_ON_CARD:
                                    storedCard.setNameOnCard(cardDataObject.get(PayuConstants.NAME_ON_CARD).toString());
                                    break;
                                case PayuConstants.CARD_NAME:
                                    storedCard.setCardName(cardDataObject.get(PayuConstants.CARD_NAME).toString());
                                    break;
                                case PayuConstants.EXPIRY_YEAR:
                                    storedCard.setExpiryYear(cardDataObject.get(PayuConstants.EXPIRY_YEAR).toString());
                                    break;
                                case PayuConstants.EXPIRY_MONTY:
                                    storedCard.setExpiryMonth(cardDataObject.get(PayuConstants.EXPIRY_MONTY).toString());
                                    break;
                                case PayuConstants.CARD_TYPE:
                                    storedCard.setCardType(cardDataObject.get(PayuConstants.CARD_TYPE).toString());
                                    break;
                                case PayuConstants.CARD_TOKEN:
                                    storedCard.setCardToken(cardDataObject.get(PayuConstants.CARD_TOKEN).toString());
                                    break;
                                case PayuConstants.IS_EXPIRED:
                                    storedCard.setIsExpired(cardDataObject.getInt(PayuConstants.IS_EXPIRED) == 0 ? false : true);
                                    break;
                                case PayuConstants.CARD_MODE:
                                    storedCard.setCardMode(cardDataObject.get(PayuConstants.CARD_MODE).toString());
                                    break;
                                case PayuConstants.CARD_CVV:
                                    storedCard.setEnableOneClickPayment(cardDataObject.getInt(PayuConstants.CARD_CVV));
                                    break;
                                case PayuConstants.CARD_NO:
                                    storedCard.setMaskedCardNumber(cardDataObject.get(PayuConstants.CARD_NO).toString());
                                    break;
                                case PayuConstants.CARD_BRAND:
                                    storedCard.setCardBrand(cardDataObject.get(PayuConstants.CARD_BRAND).toString());
                                    break;
                                case PayuConstants.CARD_BIN:
                                    storedCard.setCardBin(cardDataObject.get(PayuConstants.CARD_BIN).toString());
                                    break;
                                case PayuConstants.IS_DOMESTIC:
                                    storedCard.setIsDomestic(cardDataObject.get(PayuConstants.IS_DOMESTIC).toString());
                                    break;
                            }
                        }
                        // setting the stored card to payuUserOffer.
                        payuUserOffer.setStoredCard(storedCard);
                        Iterator<String> offerDataKeys = offerDataObject.keys();
                        ArrayList<PayuOffer> payuOffersList = new ArrayList<>();
                        while(offerDataKeys.hasNext()) { // one or more offer
                            JSONObject offerObject = offerDataObject.getJSONObject(offerDataKeys.next());
                            Iterator<String> offerKeys = offerObject.keys();
                            PayuOffer payuOffer = new PayuOffer();
                            while (offerKeys.hasNext()) {
                                switch (offerKeys.next()) {
                                    case PayuConstants.STATUS:
                                        payuOffer.setStatus(offerObject.get(PayuConstants.STATUS).toString());
                                        break;
                                    case PayuConstants.MSG:
                                        payuOffer.setMsg(offerObject.get(PayuConstants.MSG).toString());
                                        break;
                                    case PayuConstants.ERROR_CODE:
                                        payuOffer.setErrorCode(offerObject.get(PayuConstants.ERROR_CODE).toString());
                                        break;
                                    case PayuConstants.OFFER_KEY:
                                        payuOffer.setOfferKey(offerObject.get(PayuConstants.OFFER_KEY).toString());
                                        break;
                                    case PayuConstants.OFFER_TYPE:
                                        payuOffer.setOfferType(offerObject.get(PayuConstants.OFFER_TYPE).toString());
                                        break;
                                    case PayuConstants.OFFER_AVAILED_COUNT:
                                        payuOffer.setOfferAvailedCount(offerObject.get(PayuConstants.OFFER_AVAILED_COUNT).toString());
                                        break;
                                    case PayuConstants.OFFER_REMAINING_COUNT:
                                        payuOffer.setOfferRemainingCount(offerObject.get(PayuConstants.OFFER_REMAINING_COUNT).toString());
                                        break;
                                    case PayuConstants.DISCOUNT:
                                        payuOffer.setDiscount(offerObject.get(PayuConstants.DISCOUNT).toString());
                                        break;
                                    case PayuConstants.CATEGORY:
                                        payuOffer.setCategory(offerObject.get(PayuConstants.CATEGORY).toString());
                                        break;
                                    case PayuConstants.ALLOWED_ON:
                                        ArrayList<String> allowedOnList = new ArrayList<>();
                                        for (String token : offerObject.get(PayuConstants.ALLOWED_ON).toString().split(",")) {
                                            allowedOnList.add(token);
                                        }
                                        payuOffer.setAllowedOn(allowedOnList);
                                }

                            }
                            // adding offer to offerList.
                            payuOffersList.add(payuOffer);
                        }
                        // adding payuOfferList to payuUserOffer.
                        payuUserOffer.setAvailableCardOffers(payuOffersList);
                        payuUserOfferArrayList.add(payuUserOffer);
                    }
                    payuOfferDetails.setUserOffersList(payuUserOfferArrayList);
                    // setting final user details and offer details to payu response.
                    payuResponse.setPayuOfferDetails(payuOfferDetails);

                }else if(response.get(PayuConstants.DATA_KEY).toString().contentEquals(PayuConstants.OFFER_KEY)){ // dealing with card number or nb. (applicable to one or more offer keys)

                    // when more than one offer key is passed we will have more than one payuoffer.
                    JSONObject offerDetailsObject = response.getJSONObject("offer_key");
                    Iterator<String> keys = offerDetailsObject.keys();
                    ArrayList<PayuOffer> offerDetailsList = new ArrayList<>();
                    while (keys.hasNext()) {
                        // offerObject holds the current offer.
                        JSONObject offerObject = offerDetailsObject.getJSONObject(keys.next());
                        PayuOffer payuOffer = new PayuOffer();
                        Iterator<String> offerKeys = offerObject.keys();
                        while(offerKeys.hasNext()) {
                            switch (offerKeys.next()) {
                                case PayuConstants.STATUS:
                                    payuOffer.setStatus(offerObject.get(PayuConstants.STATUS).toString());
                                    break;
                                case PayuConstants.MSG:
                                    payuOffer.setMsg(offerObject.get(PayuConstants.MSG).toString());
                                    break;
                                case PayuConstants.ERROR_CODE:
                                    payuOffer.setErrorCode(offerObject.get(PayuConstants.ERROR_CODE).toString());
                                    break;
                                case PayuConstants.OFFER_KEY:
                                    payuOffer.setOfferKey(offerObject.get(PayuConstants.OFFER_KEY).toString());
                                    break;
                                case PayuConstants.OFFER_TYPE:
                                    payuOffer.setOfferType(offerObject.get(PayuConstants.OFFER_TYPE).toString());
                                    break;
                                case PayuConstants.OFFER_AVAILED_COUNT:
                                    payuOffer.setOfferAvailedCount(offerObject.get(PayuConstants.OFFER_AVAILED_COUNT).toString());
                                    break;
                                case PayuConstants.OFFER_REMAINING_COUNT:
                                    payuOffer.setOfferRemainingCount(offerObject.get(PayuConstants.OFFER_REMAINING_COUNT).toString());
                                    break;
                                case PayuConstants.DISCOUNT:
                                    payuOffer.setDiscount(offerObject.get(PayuConstants.DISCOUNT).toString());
                                    break;
                                case PayuConstants.CATEGORY:
                                    payuOffer.setCategory(offerObject.get(PayuConstants.CATEGORY).toString());
                                    break;
                                case PayuConstants.ALLOWED_ON:
//                                String allowedOn = offerObject.get(PayuConstants.ALLOWED_ON);
                                    ArrayList<String> allowedOnList = new ArrayList<>();
                                    for (String token : offerObject.get(PayuConstants.ALLOWED_ON).toString().split(",")) {
                                        allowedOnList.add(token);
                                    }
                                    payuOffer.setAllowedOn(allowedOnList);
                            }

                        }
                        // adding current payuoffer to offerlist.
                        offerDetailsList.add(payuOffer);
                    }
                    // setting offerDetailsList to payuOfferDetails.
                    payuOfferDetails.setPayuOfferList(offerDetailsList);
                    // setting final offers list to payu response.
                    payuResponse.setPayuOfferDetails(payuOfferDetails);
                }
            }


            if (response.has(PayuConstants.MSG)) {
                postData.setResult(response.getString(PayuConstants.MSG));
            }
            if (response.has(PayuConstants.STATUS) && response.getInt(PayuConstants.STATUS) == 0) {
                postData.setCode(PayuErrors.INVALID_HASH);
                postData.setStatus(PayuConstants.ERROR);
            } else {
                postData.setCode(PayuErrors.NO_ERROR);
                postData.setStatus(PayuConstants.SUCCESS);
            }

            payuResponse.setResponseStatus(postData);

        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mCheckOfferDetailsApiListener.onCheckOfferDetailsApiResponse(payuResponse);
    }
}
