//    Copyright (c) 2014 - 2015 payu@india.com
//
//    Permission is hereby granted, free of charge, to any person obtaining a copy
//    of this software and associated documentation files (the "Software"), to deal
//    in the Software without restriction, including without limitation the rights
//    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//    copies of the Software, and to permit persons to whom the Software is
//    furnished to do so, subject to the following conditions:
//
//    The above copyright notice and this permission notice shall be included in
//    all copies or substantial portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//    THE SOFTWARE.

package com.payu.india.Model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by franklin on 27/07/15.
 * Since its parcelable you can pass it through intent with out any difficult.
 */
public class PaymentParams implements Parcelable{

    // Mandatory params.
    private String key; // merchant key given by payu
    private String txnId; // unique transaction id generated by merchant
    private String amount; // transaction amount
    private String productInfo; // product information
    private String surl; // success url - After success transaction payu will post the final status with all other payment details to surl - Reverse hash should be calculated here.
    private String furl; // failure url - After failure transaction payu will post the final status with all other payment details to furl - Reverse hash should be calculated here.
    private String hash; // Hash should be generated at merchant's end.    sha512(key|txnid|amount|productinfo|firstname|email|udf1|udf2|udf3|udf4|udf5||||||SALT)

    // mandatory but can be empty string
    private String udf1; // user defined field 1
    private String udf2; // user defined field 1
    private String udf3; // user defined field 1
    private String udf4; // user defined field 1
    private String udf5; // user defined field 1
    private String email; // user's email
    private String firstName; // user's first name


    //optional fields

    private String userCredentials; // mandatory for store card,  format : merchantkey:someuniqueiud

    private String offerKey; // Offer will be automatically applied if offer exist.
    private String phone;
    private String lastName;
    private String address1;
    private String address2;
    private String city;
    private String state;
    private String country;
    private String zipCode;
    private String codUrl;
    private String dropCategory;
    private String enforcePayMethod;
    private String customNote;
    private String noteCategory;
    private String shippingFirstName;
    private String shippingLastName;
    private String shippingAddress1;
    private String shippingAddress2;
    private String shippingCity;
    private String shippingState;
    private String shippingCounty;
    private String shippingZipCode;
    private String shippingPhone;
    private int storeCard;

    // credit debit card
    private String cardNumber;
    private String cvv;
    private String expiryMonth;
    private String expiryYear;
    private String nameOnCard;
    private String cardName;

    // stored card
    private String cardToken; // given by payu while storing a card or fetching the stored cards.
    private String cardBin; // first six digits of the card

    // bank code and pg,
    private String bankCode;  // given by payu.
    private String pg; // payment mode should be anyone of (CC, NB, EMI, CASH, PAYUW )

    private int enableOneClickPayment; // flag for enabling one click payment while making payment.
    private String cardCvvMerchant;  // hash of stored merchant hash, should be sent with other payment params in case of one click payment.

    // subvention amount is an optional parameter, if merchant uses subvention amount, it should be included in payment hash as well
    private String subventionAmount;
    private String notifyURL;

    public String getNotifyURL() {
        return notifyURL;
    }

    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }

    public String getVpa() {
        return vpa;
    }

    public void setVpa(String vpa) {
        this.vpa = vpa;
    }

    private String vpa;
    protected PaymentParams(Parcel in) {
        key = in.readString();
        txnId = in.readString();
        amount = in.readString();
        productInfo = in.readString();
        firstName = in.readString();
        email = in.readString();
        surl = in.readString();
        furl = in.readString();
        hash = in.readString();
        offerKey = in.readString();
        phone = in.readString();
        lastName = in.readString();
        address1 = in.readString();
        address2 = in.readString();
        city = in.readString();
        state = in.readString();
        country = in.readString();
        zipCode = in.readString();
        udf1 = in.readString();
        udf2 = in.readString();
        udf3 = in.readString();
        udf4 = in.readString();
        udf5 = in.readString();
        codUrl = in.readString();
        dropCategory = in.readString();
        enforcePayMethod = in.readString();
        customNote = in.readString();
        noteCategory = in.readString();
        shippingFirstName = in.readString();
        shippingLastName = in.readString();
        shippingAddress1 = in.readString();
        shippingAddress2 = in.readString();
        shippingCity = in.readString();
        shippingState = in.readString();
        shippingCounty = in.readString();
        shippingZipCode = in.readString();
        shippingPhone = in.readString();
        userCredentials = in.readString();
        storeCard = in.readInt();
        cardNumber = in.readString();
        cvv = in.readString();
        expiryMonth = in.readString();
        expiryYear = in.readString();
        nameOnCard = in.readString();
        cardName = in.readString();
        cardToken = in.readString();
        cardBin = in.readString();
        bankCode = in.readString();
        pg = in.readString();
        enableOneClickPayment = in.readInt();
        cardCvvMerchant = in.readString();
        subventionAmount = in.readString();
        vpa = in.readString();
        notifyURL = in.readString();
    }

    public static final Creator<PaymentParams> CREATOR = new Creator<PaymentParams>() {
        @Override
        public PaymentParams createFromParcel(Parcel in) {
            return new PaymentParams(in);
        }

        @Override
        public PaymentParams[] newArray(int size) {
            return new PaymentParams[size];
        }
    };

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTxnId() {
        return txnId;
    }

    public void setTxnId(String txnId) {
        this.txnId = txnId;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getProductInfo() {
        return productInfo;
    }

    public void setProductInfo(String productInfo) {
        this.productInfo = productInfo;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSurl() {
        return surl;
    }

    public void setSurl(String surl) {
        this.surl = surl;
    }

    public String getFurl() {
        return furl;
    }

    public void setFurl(String furl) {
        this.furl = furl;
    }

    public String getHash() {
        return hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getOfferKey() {
        return offerKey;
    }

    public void setOfferKey(String offerKey) {
        this.offerKey = offerKey;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getAddress1() {
        return address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getUdf1() {
        return udf1;
    }

    public void setUdf1(String udf1) {
        this.udf1 = udf1;
    }

    public String getUdf2() {
        return udf2;
    }

    public void setUdf2(String udf2) {
        this.udf2 = udf2;
    }

    public String getUdf3() {
        return udf3;
    }

    public void setUdf3(String udf3) {
        this.udf3 = udf3;
    }

    public String getUdf4() {
        return udf4;
    }

    public void setUdf4(String udf4) {
        this.udf4 = udf4;
    }

    public String getUdf5() {
        return udf5;
    }

    public void setUdf5(String udf5) {
        this.udf5 = udf5;
    }

    public String getCodUrl() {
        return codUrl;
    }

    public void setCodUrl(String codUrl) {
        this.codUrl = codUrl;
    }

    public String getDropCategory() {
        return dropCategory;
    }

    public void setDropCategory(String dropCategory) {
        this.dropCategory = dropCategory;
    }

    public String getEnforcePayMethod() {
        return enforcePayMethod;
    }

    public void setEnforcePayMethod(String enforcePayMethod) {
        this.enforcePayMethod = enforcePayMethod;
    }

    public String getCustomNote() {
        return customNote;
    }

    public void setCustomNote(String customNote) {
        this.customNote = customNote;
    }

    public String getNoteCategory() {
        return noteCategory;
    }

    public void setNoteCategory(String noteCategory) {
        this.noteCategory = noteCategory;
    }

    public String getShippingFirstName() {
        return shippingFirstName;
    }

    public void setShippingFirstName(String shippingFirstName) {
        this.shippingFirstName = shippingFirstName;
    }

    public String getShippingLastName() {
        return shippingLastName;
    }

    public void setShippingLastName(String shippingLastName) {
        this.shippingLastName = shippingLastName;
    }

    public String getShippingAddress1() {
        return shippingAddress1;
    }

    public void setShippingAddress1(String shippingAddress1) {
        this.shippingAddress1 = shippingAddress1;
    }

    public String getShippingAddress2() {
        return shippingAddress2;
    }

    public void setShippingAddress2(String shippingAddress2) {
        this.shippingAddress2 = shippingAddress2;
    }

    public String getShippingCity() {
        return shippingCity;
    }

    public void setShippingCity(String shippingCity) {
        this.shippingCity = shippingCity;
    }

    public String getShippingState() {
        return shippingState;
    }

    public void setShippingState(String shippingState) {
        this.shippingState = shippingState;
    }

    public String getShippingCounty() {
        return shippingCounty;
    }

    public void setShippingCounty(String shippingCounty) {
        this.shippingCounty = shippingCounty;
    }

    public String getShippingZipCode() {
        return shippingZipCode;
    }

    public void setShippingZipCode(String shippingZipCode) {
        this.shippingZipCode = shippingZipCode;
    }

    public String getShippingPhone() {
        return shippingPhone;
    }

    public void setShippingPhone(String shippingPhone) {
        this.shippingPhone = shippingPhone;
    }

    public String getUserCredentials() {
        return userCredentials;
    }

    public void setUserCredentials(String userCredentials) {
        this.userCredentials = userCredentials;
    }

    public int getStoreCard() {
        return storeCard;
    }

    public void setStoreCard(int storeCard) {
        this.storeCard = storeCard;
    }

    public String getCardNumber() {
        return cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getCvv() {
        return cvv;
    }

    public void setCvv(String cvv) {
        this.cvv = cvv;
    }

    public String getExpiryMonth() {
        return expiryMonth;
    }

    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public String getExpiryYear() {
        return expiryYear;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public String getNameOnCard() {
        return nameOnCard;
    }

    public void setNameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
    }

    public String getCardName() {
        return cardName;
    }

    public void setCardName(String cardName) {
        this.cardName = cardName;
    }

    public String getCardToken() {
        return cardToken;
    }

    public void setCardToken(String cardToken) {
        this.cardToken = cardToken;
    }

    public String getCardBin() {
        return cardBin;
    }

    public void setCardBin(String cardBin) {
        this.cardBin = cardBin;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getPg() {
        return pg;
    }

    public void setPg(String pg) {
        this.pg = pg;
    }

    public int getEnableOneClickPayment() {
        return enableOneClickPayment;
    }

    public void setEnableOneClickPayment(int enableOneClickPayment) {
        this.enableOneClickPayment = enableOneClickPayment;
    }

    public String getCardCvvMerchant() {
        return cardCvvMerchant;
    }

    public void setCardCvvMerchant(String cardCvvMerchant) {
        this.cardCvvMerchant = cardCvvMerchant;
    }

    public String getSubventionAmount() {
        return subventionAmount;
    }

    public void setSubventionAmount(String subventionAmount) {
        this.subventionAmount = subventionAmount;
    }

    public PaymentParams() {}

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(key);
        dest.writeString(txnId);
        dest.writeString(amount);
        dest.writeString(productInfo);
        dest.writeString(firstName);
        dest.writeString(email);
        dest.writeString(surl);
        dest.writeString(furl);
        dest.writeString(hash);
        dest.writeString(offerKey);
        dest.writeString(phone);
        dest.writeString(lastName);
        dest.writeString(address1);
        dest.writeString(address2);
        dest.writeString(city);
        dest.writeString(state);
        dest.writeString(country);
        dest.writeString(zipCode);
        dest.writeString(udf1);
        dest.writeString(udf2);
        dest.writeString(udf3);
        dest.writeString(udf4);
        dest.writeString(udf5);
        dest.writeString(codUrl);
        dest.writeString(dropCategory);
        dest.writeString(enforcePayMethod);
        dest.writeString(customNote);
        dest.writeString(noteCategory);
        dest.writeString(shippingFirstName);
        dest.writeString(shippingLastName);
        dest.writeString(shippingAddress1);
        dest.writeString(shippingAddress2);
        dest.writeString(shippingCity);
        dest.writeString(shippingState);
        dest.writeString(shippingCounty);
        dest.writeString(shippingZipCode);
        dest.writeString(shippingPhone);
        dest.writeString(userCredentials);
        dest.writeInt(storeCard);
        dest.writeString(cardNumber);
        dest.writeString(cvv);
        dest.writeString(expiryMonth);
        dest.writeString(expiryYear);
        dest.writeString(nameOnCard);
        dest.writeString(cardName);
        dest.writeString(cardToken);
        dest.writeString(cardBin);
        dest.writeString(bankCode);
        dest.writeString(pg);
        dest.writeInt(enableOneClickPayment);
        dest.writeString(cardCvvMerchant);
        dest.writeString(subventionAmount);
        dest.writeString(vpa);
        dest.writeString(notifyURL);
    }

}
