package com.payu.india.Tasks;

import android.os.AsyncTask;

import com.payu.india.CallBackHandler.OnetapCallback;
import com.payu.india.Interfaces.OneClickPaymentListener;
import com.payu.india.Payu.PayuConstants;

import org.json.JSONObject;

/**
 * Created by harmeet on 2/19/16.
 */
public class StoreMerchantHashTask extends AsyncTask<String, Void, Void> {

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
    }

    @Override
    protected Void doInBackground(String... params) {

        String payuResponse = params[0];

        try{
            JSONObject jsonObject = new JSONObject(payuResponse);


            if (jsonObject.has(PayuConstants.CARD_TOKEN) && jsonObject.has(PayuConstants.MERCHANT_HASH)) { // we have merchant hash, lets store it merchant server. card_merchant_param && cardToken

                OneClickPaymentListener mOneTapCallBack = OnetapCallback.getOneTapCallback();
                if(mOneTapCallBack != null)
                    mOneTapCallBack.saveOneClickHash(jsonObject.get(PayuConstants.CARD_TOKEN).toString(), jsonObject.get(PayuConstants.MERCHANT_HASH).toString());
            }

        }
        catch (Exception e){
            e.printStackTrace();
        }

        return null;
    }

    @Override
    protected void onPostExecute(Void aVoid) {
        super.onPostExecute(aVoid);
    }
}

