/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.VerifyPaymentApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.TransactionDetails;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class VerifyPaymentTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    VerifyPaymentApiListener mVerifyPaymentApiListener;

    public VerifyPaymentTask(VerifyPaymentApiListener verifyPaymentApiListener) {
        this.mVerifyPaymentApiListener = verifyPaymentApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        ArrayList<TransactionDetails> transactionDetailsCollections = new ArrayList<TransactionDetails>();
        try {
            int i;
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            byte[] postParamsByte = payuConfig.getData().getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postParamsByte.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postParamsByte);
            InputStream responseInputStream = conn.getInputStream();
            StringBuffer responseStringBuffer = new StringBuffer();
            byte[] byteContainer = new byte[1024];
            while ((i = responseInputStream.read(byteContainer)) != -1) {
                responseStringBuffer.append(new String(byteContainer, 0, i));
            }
            JSONObject response = new JSONObject(responseStringBuffer.toString());
            if (response.has("msg")) {
                postData.setResult(response.getString("msg"));
            }
            if (response.has("status") && response.getInt("status") == 0) {
                postData.setCode(5019);
                postData.setStatus("ERROR");
            } else if (response.has("status") && response.getInt("status") == 1) {
                postData.setCode(0);
                postData.setStatus("SUCCESS");
                JSONObject transactionDetailsList = response.getJSONObject("transaction_details");
                Iterator transactionDetailsListIterator = transactionDetailsList.keys();
                while (transactionDetailsListIterator.hasNext()) {
                    JSONObject transactionDetails = transactionDetailsList.getJSONObject((String)transactionDetailsListIterator.next());
                    Iterator transactionDetailsIterator = transactionDetails.keys();
                    TransactionDetails transactionDetailsObject = new TransactionDetails();
                    while (transactionDetailsIterator.hasNext()) {
                        String key;
                        switch (key = (String)transactionDetailsIterator.next()) {
                            case "mihpayid": {
                                transactionDetailsObject.setMihpayId(transactionDetails.getString("mihpayid"));
                                break;
                            }
                            case "request_id": {
                                transactionDetailsObject.setRequestId(transactionDetails.getString("request_id"));
                                break;
                            }
                            case "bank_ref_num": {
                                transactionDetailsObject.setBankReferenceNumber(transactionDetails.getString("bank_ref_num"));
                                break;
                            }
                            case "amt": {
                                transactionDetailsObject.setAmount(transactionDetails.getString("amt"));
                                break;
                            }
                            case "txnid": {
                                transactionDetailsObject.setTxnid(transactionDetails.getString("txnid"));
                                break;
                            }
                            case "additional_charges": {
                                transactionDetailsObject.setAdditionalCharges(transactionDetails.getString("additional_charges"));
                                break;
                            }
                            case "productinfo": {
                                transactionDetailsObject.setProductinfo(transactionDetails.getString("productinfo"));
                                break;
                            }
                            case "firstname": {
                                transactionDetailsObject.setFirstname(transactionDetails.getString("firstname"));
                                break;
                            }
                            case "bankcode": {
                                transactionDetailsObject.setBankCode(transactionDetails.getString("bankcode"));
                                break;
                            }
                            case "udf1": {
                                transactionDetailsObject.setUdf1(transactionDetails.getString("udf1"));
                                break;
                            }
                            case "udf2": {
                                transactionDetailsObject.setUdf2(transactionDetails.getString("udf2"));
                                break;
                            }
                            case "udf3": {
                                transactionDetailsObject.setUdf3(transactionDetails.getString("udf3"));
                                break;
                            }
                            case "udf4": {
                                transactionDetailsObject.setUdf4(transactionDetails.getString("udf4"));
                                break;
                            }
                            case "udf5": {
                                transactionDetailsObject.setUdf5(transactionDetails.getString("udf5"));
                                break;
                            }
                            case "field9": {
                                transactionDetailsObject.setField9(transactionDetails.getString("field9"));
                                break;
                            }
                            case "error_code": {
                                transactionDetailsObject.setErrorCode(transactionDetails.getString("error_code"));
                                break;
                            }
                            case "card_type": {
                                transactionDetailsObject.setCardtype(transactionDetails.getString("card_type"));
                                break;
                            }
                            case "error_Message": {
                                transactionDetailsObject.setErrorMessage(transactionDetails.getString("error_Message"));
                                break;
                            }
                            case "net_amount_debit": {
                                transactionDetailsObject.setNetAmountDebit(transactionDetails.getString("net_amount_debit"));
                                break;
                            }
                            case "disc": {
                                transactionDetailsObject.setDiscount(transactionDetails.getString("disc"));
                                break;
                            }
                            case "mode": {
                                transactionDetailsObject.setMode(transactionDetails.getString("mode"));
                                break;
                            }
                            case "PG_TYPE": {
                                transactionDetailsObject.setPgType(transactionDetails.getString("PG_TYPE"));
                                break;
                            }
                            case "card_no": {
                                transactionDetailsObject.setCardNo(transactionDetails.getString("card_no"));
                                break;
                            }
                            case "addedon": {
                                transactionDetailsObject.setAddedon(transactionDetails.getString("addedon"));
                                break;
                            }
                            case "status": {
                                transactionDetailsObject.setStatus(transactionDetails.getString("status"));
                                break;
                            }
                            case "unmappedstatus": {
                                transactionDetailsObject.setUnmappedStatus(transactionDetails.getString("unmappedstatus"));
                                break;
                            }
                            case "Merchant_UTR": {
                                transactionDetailsObject.setMerchantUTR(transactionDetails.getString("Merchant_UTR"));
                                break;
                            }
                            case "Settled_At": {
                                transactionDetailsObject.setSettledAt(transactionDetails.getString("Settled_At"));
                            }
                        }
                    }
                    transactionDetailsCollections.add(transactionDetailsObject);
                }
                payuResponse.setTransactionDetailsList(transactionDetailsCollections);
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        payuResponse.setResponseStatus(postData);
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mVerifyPaymentApiListener.onVerifyPaymentResponse(payuResponse);
    }
}

