/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.CallBackHandler.OnetapCallback;
import com.payu.india.Interfaces.OneClickPaymentListener;
import com.payu.india.Interfaces.PaymentRelatedDetailsListener;
import com.payu.india.Model.Emi;
import com.payu.india.Model.PaymentDetails;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Model.StoredCard;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class GetPaymentRelatedDetailsTask
extends AsyncTask<PayuConfig, Void, HashMap<String, String>> {
    PayuConfig payuConfig;
    HashMap<String, String> mOneClickCardTokens;
    PaymentRelatedDetailsListener mPaymentRelatedDetailsListener;

    public GetPaymentRelatedDetailsTask(PaymentRelatedDetailsListener paymentRelatedDetailsListener) {
        this.mPaymentRelatedDetailsListener = paymentRelatedDetailsListener;
    }

    protected HashMap<String, String> doInBackground(PayuConfig ... params) {
        OneClickPaymentListener mOneTapCallBack;
        this.payuConfig = params[0];
        String mUserCredentials = "";
        String patternText = "var1=([^&]*)";
        String searchString = this.payuConfig.getData();
        Pattern pattern = Pattern.compile(patternText);
        Matcher matcher = pattern.matcher(searchString);
        while (matcher.find()) {
            mUserCredentials = matcher.group(1);
        }
        if (!mUserCredentials.equals("") && !mUserCredentials.equals("default") && (mOneTapCallBack = OnetapCallback.getOneTapCallback()) != null) {
            return mOneTapCallBack.getAllOneClickHash(mUserCredentials);
        }
        return null;
    }

    protected void onPostExecute(HashMap<String, String> oneClickCardTokens) {
        super.onPostExecute(oneClickCardTokens);
        this.mOneClickCardTokens = oneClickCardTokens;
        FetchPaymentDetailsTask mTask = new FetchPaymentDetailsTask();
        mTask.execute(new PayuConfig[]{this.payuConfig});
    }

    class FetchPaymentDetailsTask
    extends AsyncTask<PayuConfig, String, PayuResponse> {
        FetchPaymentDetailsTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected PayuResponse doInBackground(PayuConfig ... params) {
            PayuResponse payuResponse = new PayuResponse();
            PostData postData = new PostData();
            try {
                int i;
                URL url = null;
                PayuConfig payuConfig = params[0];
                switch (payuConfig.getEnvironment()) {
                    case 0: {
                        url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                        break;
                    }
                    case 1: {
                        url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    case 2: {
                        url = new URL("https://test.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    case 3: {
                        url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                        break;
                    }
                    default: {
                        url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    }
                }
                byte[] postParamsByte = payuConfig.getData().getBytes("UTF-8");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", String.valueOf(postParamsByte.length));
                conn.setDoOutput(true);
                conn.getOutputStream().write(postParamsByte);
                InputStream responseInputStream = conn.getInputStream();
                StringBuffer responseStringBuffer = new StringBuffer();
                byte[] byteContainer = new byte[1024];
                while ((i = responseInputStream.read(byteContainer)) != -1) {
                    responseStringBuffer.append(new String(byteContainer, 0, i));
                }
                JSONObject response = new JSONObject(responseStringBuffer.toString());
                if (response.has("ibiboCodes")) {
                    Iterator keysIterator;
                    PaymentDetails paymentDetails;
                    String bankCode;
                    Iterator keysIterator2;
                    JSONObject ibiboCodes = response.getJSONObject("ibiboCodes");
                    if (ibiboCodes.has("creditcard")) {
                        JSONObject creditCardCollections = ibiboCodes.getJSONObject("creditcard");
                        ArrayList<PaymentDetails> ccList = new ArrayList<PaymentDetails>();
                        keysIterator2 = creditCardCollections.keys();
                        while (keysIterator2.hasNext()) {
                            bankCode = (String)keysIterator2.next();
                            JSONObject ccObject = creditCardCollections.getJSONObject(bankCode);
                            paymentDetails = new PaymentDetails();
                            paymentDetails.setBankCode(bankCode);
                            paymentDetails.setBankId(ccObject.getString("bank_id"));
                            paymentDetails.setBankName(ccObject.getString("title"));
                            paymentDetails.setPgId(ccObject.getString("pgId"));
                            ccList.add(paymentDetails);
                        }
                        payuResponse.setCreditCard(ccList);
                    }
                    if (ibiboCodes.has("debitcard")) {
                        JSONObject debitCardCollections = ibiboCodes.getJSONObject("debitcard");
                        ArrayList<PaymentDetails> dbList = new ArrayList<PaymentDetails>();
                        keysIterator2 = debitCardCollections.keys();
                        while (keysIterator2.hasNext()) {
                            bankCode = (String)keysIterator2.next();
                            PaymentDetails paymentDetails2 = new PaymentDetails();
                            JSONObject dcObject = debitCardCollections.getJSONObject(bankCode);
                            paymentDetails2.setBankCode(bankCode);
                            paymentDetails2.setBankId(dcObject.getString("bank_id"));
                            paymentDetails2.setBankName(dcObject.getString("title"));
                            paymentDetails2.setPgId(dcObject.getString("pgId"));
                            dbList.add(paymentDetails2);
                        }
                        payuResponse.setDebitCard(dbList);
                    }
                    if (ibiboCodes.has("netbanking")) {
                        JSONObject netBanksCollections = ibiboCodes.getJSONObject("netbanking");
                        keysIterator = netBanksCollections.keys();
                        ArrayList<PaymentDetails> nbList = new ArrayList<PaymentDetails>();
                        while (keysIterator.hasNext()) {
                            bankCode = (String)keysIterator.next();
                            JSONObject netBank = netBanksCollections.getJSONObject(bankCode);
                            paymentDetails = new PaymentDetails();
                            paymentDetails.setBankCode(bankCode);
                            paymentDetails.setBankId(netBank.getString("bank_id"));
                            paymentDetails.setBankName(netBank.getString("title"));
                            paymentDetails.setPgId(netBank.getString("pgId"));
                            nbList.add(paymentDetails);
                        }
                        Collections.sort(nbList, new PaymentDetailsComparator());
                        payuResponse.setNetBanks(nbList);
                    }
                    if (ibiboCodes.has("cashcard")) {
                        JSONObject cashCardCollections = ibiboCodes.getJSONObject("cashcard");
                        keysIterator = cashCardCollections.keys();
                        ArrayList<PaymentDetails> cashCardList = new ArrayList<PaymentDetails>();
                        while (keysIterator.hasNext()) {
                            bankCode = (String)keysIterator.next();
                            JSONObject cashCardJson = cashCardCollections.getJSONObject(bankCode);
                            paymentDetails = new PaymentDetails();
                            paymentDetails.setBankCode(bankCode);
                            paymentDetails.setBankId(cashCardJson.getString("bank_id"));
                            paymentDetails.setBankName(cashCardJson.getString("title"));
                            paymentDetails.setPgId(cashCardJson.getString("pgId"));
                            cashCardList.add(paymentDetails);
                        }
                        Collections.sort(cashCardList, new PaymentDetailsComparator());
                        payuResponse.setCashCard(cashCardList);
                    }
                    if (ibiboCodes.has("ivr")) {
                        JSONObject ivrCCCollections = ibiboCodes.getJSONObject("ivr");
                        keysIterator = ivrCCCollections.keys();
                        ArrayList<PaymentDetails> ivrCCList = new ArrayList<PaymentDetails>();
                        while (keysIterator.hasNext()) {
                            bankCode = (String)keysIterator.next();
                            JSONObject ivrccObject = ivrCCCollections.getJSONObject(bankCode);
                            paymentDetails = new PaymentDetails();
                            paymentDetails.setBankCode(bankCode);
                            paymentDetails.setBankId(ivrccObject.getString("bank_id"));
                            paymentDetails.setBankName(ivrccObject.getString("title"));
                            paymentDetails.setPgId(ivrccObject.getString("pgId"));
                            ivrCCList.add(paymentDetails);
                        }
                        payuResponse.setIvr(ivrCCList);
                    }
                    if (ibiboCodes.has("ivrdc")) {
                        JSONObject ivrDCCollections = ibiboCodes.getJSONObject("ivrdc");
                        keysIterator = ivrDCCollections.keys();
                        ArrayList<PaymentDetails> ivrDCList = new ArrayList<PaymentDetails>();
                        while (keysIterator.hasNext()) {
                            bankCode = (String)keysIterator.next();
                            JSONObject ivrdcObject = ivrDCCollections.getJSONObject(bankCode);
                            paymentDetails = new PaymentDetails();
                            paymentDetails.setBankCode(bankCode);
                            paymentDetails.setBankId(ivrdcObject.getString("bank_id"));
                            paymentDetails.setBankName(ivrdcObject.getString("title"));
                            paymentDetails.setPgId(ivrdcObject.getString("pgId"));
                            ivrDCList.add(paymentDetails);
                        }
                        payuResponse.setIvrdc(ivrDCList);
                    }
                    if (ibiboCodes.has("paisawallet")) {
                        JSONObject paisaWalletCollections = ibiboCodes.getJSONObject("paisawallet");
                        keysIterator = paisaWalletCollections.keys();
                        ArrayList<PaymentDetails> paisaWalletList = new ArrayList<PaymentDetails>();
                        while (keysIterator.hasNext()) {
                            bankCode = (String)keysIterator.next();
                            JSONObject paisaWallet = paisaWalletCollections.getJSONObject(bankCode);
                            paymentDetails = new PaymentDetails();
                            paymentDetails.setBankCode(bankCode);
                            paymentDetails.setBankId(paisaWallet.getString("bank_id"));
                            paymentDetails.setBankName(paisaWallet.getString("title"));
                            paymentDetails.setPgId(paisaWallet.getString("pgId"));
                            paisaWalletList.add(paymentDetails);
                        }
                        payuResponse.setPaisaWallet(paisaWalletList);
                    }
                    if (ibiboCodes.has("emi")) {
                        JSONObject emiObjectCollections = ibiboCodes.getJSONObject("emi");
                        keysIterator = emiObjectCollections.keys();
                        ArrayList<Emi> emiList = new ArrayList<Emi>();
                        while (keysIterator.hasNext()) {
                            bankCode = (String)keysIterator.next();
                            JSONObject emiObject = emiObjectCollections.getJSONObject(bankCode);
                            Emi emi = new Emi();
                            emi.setBankCode(bankCode);
                            emi.setBankName(emiObject.getString("bank"));
                            emi.setBankTitle(emiObject.getString("title"));
                            emi.setPgId(emiObject.getString("pgId"));
                            emiList.add(emi);
                        }
                        Collections.sort(emiList, new EmiComparator());
                        payuResponse.setEmi(emiList);
                    }
                }
                if (response.has("userCards") && response.getJSONObject("userCards").has("user_cards")) {
                    JSONObject cardsList = response.getJSONObject("userCards").getJSONObject("user_cards");
                    Iterator keysIterator = cardsList.keys();
                    ArrayList<StoredCard> userCardArrayList = new ArrayList<StoredCard>();
                    while (keysIterator.hasNext()) {
                        String cardToken = (String)keysIterator.next();
                        StoredCard userCard = new StoredCard();
                        JSONObject card = cardsList.getJSONObject(cardToken);
                        userCard.setNameOnCard(card.getString("name_on_card"));
                        userCard.setCardName(card.getString("card_name"));
                        userCard.setExpiryYear(card.getString("expiry_year"));
                        userCard.setExpiryMonth(card.getString("expiry_month"));
                        userCard.setCardType(card.getString("card_type"));
                        userCard.setCardToken(card.getString("card_token"));
                        userCard.setIsExpired(card.getInt("is_expired") != 0);
                        userCard.setCardMode(card.getString("card_mode"));
                        userCard.setMaskedCardNumber(card.getString("card_no"));
                        userCard.setCardBrand(card.getString("card_brand"));
                        userCard.setCardBin(card.getString("card_bin"));
                        userCard.setIsDomestic(card.getString("isDomestic"));
                        userCard.setIssuingBank(card.getString("issuingBank"));
                        if (card.has("card_cvv")) {
                            userCard.setEnableOneClickPayment(card.getInt("card_cvv"));
                            if (GetPaymentRelatedDetailsTask.this.mOneClickCardTokens != null && GetPaymentRelatedDetailsTask.this.mOneClickCardTokens.get(userCard.getCardToken()) != null) {
                                userCard.setOneTapCard(1);
                                userCard.setMerchantHash(GetPaymentRelatedDetailsTask.this.mOneClickCardTokens.get(userCard.getCardToken()));
                            } else {
                                userCard.setOneTapCard(0);
                                userCard.setMerchantHash(null);
                            }
                        }
                        userCardArrayList.add(userCard);
                        userCard = null;
                    }
                    payuResponse.setStoredCards(userCardArrayList);
                }
                if (response.has("status") && response.getString("status").contentEquals("0")) {
                    postData = new PostData();
                    postData.setCode(5019);
                    postData.setStatus("ERROR");
                    postData.setResult(response.getString("msg"));
                } else {
                    postData.setCode(0);
                    postData.setResult("Data fetched successfully, Stored card status: " + response.getJSONObject("userCards").getString("msg"));
                    postData.setStatus("SUCCESS");
                }
            }
            catch (ProtocolException e) {
                postData.setCode(5016);
                postData.setStatus("ERROR");
                postData.setResult(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                postData.setCode(5004);
                postData.setStatus("ERROR");
                postData.setResult(e.getMessage());
            }
            catch (JSONException e) {
                postData.setCode(5014);
                postData.setStatus("ERROR");
                postData.setResult(e.getMessage());
            }
            catch (IOException e) {
                postData.setCode(5016);
                postData.setStatus("ERROR");
                postData.setResult(e.getMessage());
            }
            payuResponse.setResponseStatus(postData);
            return payuResponse;
        }

        protected void onPostExecute(PayuResponse payuResponse) {
            super.onPostExecute((Object)payuResponse);
            GetPaymentRelatedDetailsTask.this.mPaymentRelatedDetailsListener.onPaymentRelatedDetailsResponse(payuResponse);
        }

        class PaymentDetailsComparator
        implements Comparator<PaymentDetails> {
            PaymentDetailsComparator() {
            }

            @Override
            public int compare(PaymentDetails p1, PaymentDetails p2) {
                return p1.getBankName().compareTo(p2.getBankName());
            }
        }

        class EmiComparator
        implements Comparator<Emi> {
            EmiComparator() {
            }

            @Override
            public int compare(Emi p1, Emi p2) {
                return p1.getBankName().compareTo(p2.getBankName());
            }
        }
    }
}

