/*
 * Decompiled with CFR 0.152.
 */
package com.payu.india.Tasks;

import android.os.AsyncTask;
import com.payu.india.Interfaces.CheckOfferDetailsApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckOfferDetailsTask
extends AsyncTask<PayuConfig, String, PayuResponse> {
    CheckOfferDetailsApiListener mCheckOfferDetailsApiListener;

    public CheckOfferDetailsTask(CheckOfferDetailsApiListener checkOfferDetailsApiListener) {
        this.mCheckOfferDetailsApiListener = checkOfferDetailsApiListener;
    }

    protected PayuResponse doInBackground(PayuConfig ... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();
        try {
            int i;
            URL url = null;
            PayuConfig payuConfig = params[0];
            switch (payuConfig.getEnvironment()) {
                case 0: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                    break;
                }
                case 1: {
                    url = new URL("https://mobiletest.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 2: {
                    url = new URL("https://test.payu.in/merchant/postservice?form=2");
                    break;
                }
                case 3: {
                    url = new URL("https://mobiledev.payu.in/merchant/postservice?form=2");
                    break;
                }
                default: {
                    url = new URL("https://info.payu.in/merchant/postservice.php?form=2");
                }
            }
            byte[] postParamsByte = payuConfig.getData().getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postParamsByte.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postParamsByte);
            InputStream responseInputStream = conn.getInputStream();
            StringBuffer responseStringBuffer = new StringBuffer();
            byte[] byteContainer = new byte[1024];
            while ((i = responseInputStream.read(byteContainer)) != -1) {
                responseStringBuffer.append(new String(byteContainer, 0, i));
            }
            JSONObject response = new JSONObject(responseStringBuffer.toString());
            if (response.has("offer_key")) {
                JSONObject offerDetailsObject = response.getJSONObject("offer_key");
                Iterator keys = offerDetailsObject.keys();
                ArrayList<PayuOffer> offerDetailsList = new ArrayList<PayuOffer>();
                while (keys.hasNext()) {
                    JSONObject offerObject = offerDetailsObject.getJSONObject((String)keys.next());
                    PayuOffer payuOffer = new PayuOffer();
                    Iterator offerKeys = offerObject.keys();
                    while (offerKeys.hasNext()) {
                        switch ((String)offerKeys.next()) {
                            case "status": {
                                payuOffer.setStatus(offerObject.get("status").toString());
                                break;
                            }
                            case "msg": {
                                payuOffer.setMsg(offerObject.get("msg").toString());
                                break;
                            }
                            case "error_code": {
                                payuOffer.setErrorCode(offerObject.get("error_code").toString());
                                break;
                            }
                            case "offer_key": {
                                payuOffer.setOfferKey(offerObject.get("offer_key").toString());
                                break;
                            }
                            case "offer_type": {
                                payuOffer.setOfferType(offerObject.get("offer_type").toString());
                                break;
                            }
                            case "offer_availed_count": {
                                payuOffer.setOfferAvailedCount(offerObject.get("offer_availed_count").toString());
                                break;
                            }
                            case "offer_remaining_count": {
                                payuOffer.setOfferRemainingCount(offerObject.get("offer_remaining_count").toString());
                                break;
                            }
                            case "discount": {
                                payuOffer.setDiscount(offerObject.get("discount").toString());
                                break;
                            }
                            case "category": {
                                payuOffer.setCategory(offerObject.get("category").toString());
                            }
                        }
                    }
                    offerDetailsList.add(payuOffer);
                }
                payuResponse.setOfferDetailsList(offerDetailsList);
            }
            if (response.has("msg")) {
                postData.setResult(response.getString("msg"));
            }
            if (response.has("status") && response.getInt("status") == 0) {
                postData.setCode(5019);
                postData.setStatus("ERROR");
            } else {
                postData.setCode(0);
                postData.setStatus("SUCCESS");
            }
            payuResponse.setResponseStatus(postData);
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return payuResponse;
    }

    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute((Object)payuResponse);
        this.mCheckOfferDetailsApiListener.onCheckOfferDetailsApiResponse(payuResponse);
    }
}

