package com.payu.india.Tasks;

import android.os.AsyncTask;

import com.payu.india.Interfaces.CheckOfferDetailsApiListener;
import com.payu.india.Model.PayuConfig;
import com.payu.india.Model.PayuOffer;
import com.payu.india.Model.PayuResponse;
import com.payu.india.Model.PostData;
import com.payu.india.Payu.PayuConstants;
import com.payu.india.Payu.PayuErrors;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * Created by franklin.michael on 08/03/16.
 * Async task which takes care of Getting all the offer details for one or more offer keys
 * Takes PayuConfig as input and sends PayuResponse to the calling activity
 * Activity which calls {@link CheckOfferDetailsTask} should implement {@link CheckOfferDetailsApiListener}
 */
public class CheckOfferDetailsTask extends AsyncTask<PayuConfig, String, PayuResponse> {

    CheckOfferDetailsApiListener mCheckOfferDetailsApiListener;

    public CheckOfferDetailsTask(CheckOfferDetailsApiListener checkOfferDetailsApiListener) {
        mCheckOfferDetailsApiListener = checkOfferDetailsApiListener;
    }

    @Override
    protected PayuResponse doInBackground(PayuConfig... params) {
        PayuResponse payuResponse = new PayuResponse();
        PostData postData = new PostData();

        try {
            URL url = null;
            // get the payuConfig first
            PayuConfig payuConfig = params[0];

            // set the environment
            switch (payuConfig.getEnvironment()) {
                case PayuConstants.PRODUCTION_ENV:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_STAGING_ENV:
                    url = new URL(PayuConstants.MOBILE_TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.STAGING_ENV:
                    url = new URL(PayuConstants.TEST_FETCH_DATA_URL);
                    break;
                case PayuConstants.MOBILE_DEV_ENV:
                    url = new URL(PayuConstants.MOBILE_DEV_FETCH_DATA_URL);
                    break;
                default:
                    url = new URL(PayuConstants.PRODUCTION_FETCH_DATA_URL);
                    break;
            }

            byte[] postParamsByte = payuConfig.getData().getBytes("UTF-8");

            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postParamsByte.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postParamsByte);

            InputStream responseInputStream = conn.getInputStream();
            StringBuffer responseStringBuffer = new StringBuffer();
            byte[] byteContainer = new byte[1024];
            for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                responseStringBuffer.append(new String(byteContainer, 0, i));
            }

            JSONObject response = new JSONObject(responseStringBuffer.toString());

            if(response.has("offer_key")){
                JSONObject offerDetailsObject = response.getJSONObject("offer_key");
                Iterator<String> keys = offerDetailsObject.keys();
                ArrayList<PayuOffer> offerDetailsList = new ArrayList<>();
                while (keys.hasNext()) {
                    JSONObject offerObject = offerDetailsObject.getJSONObject(keys.next());
                    PayuOffer payuOffer = new PayuOffer();
                    Iterator<String> offerKeys = offerObject.keys();
                    while(offerKeys.hasNext()) {
                        switch (offerKeys.next()) {
                            case PayuConstants.STATUS:
                                payuOffer.setStatus(offerObject.get(PayuConstants.STATUS).toString());
                                break;
                            case PayuConstants.MSG:
                                payuOffer.setMsg(offerObject.get(PayuConstants.MSG).toString());
                                break;
                            case PayuConstants.ERROR_CODE:
                                payuOffer.setErrorCode(offerObject.get(PayuConstants.ERROR_CODE).toString());
                                break;
                            case PayuConstants.OFFER_KEY:
                                payuOffer.setOfferKey(offerObject.get(PayuConstants.OFFER_KEY).toString());
                                break;
                            case PayuConstants.OFFER_TYPE:
                                payuOffer.setOfferType(offerObject.get(PayuConstants.OFFER_TYPE).toString());
                                break;
                            case PayuConstants.OFFER_AVAILED_COUNT:
                                payuOffer.setOfferAvailedCount(offerObject.get(PayuConstants.OFFER_AVAILED_COUNT).toString());
                                break;
                            case PayuConstants.OFFER_REMAINING_COUNT:
                                payuOffer.setOfferRemainingCount(offerObject.get(PayuConstants.OFFER_REMAINING_COUNT).toString());
                                break;
                            case PayuConstants.DISCOUNT:
                                payuOffer.setDiscount(offerObject.get(PayuConstants.DISCOUNT).toString());
                                break;
                            case PayuConstants.CATEGORY:
                                payuOffer.setCategory(offerObject.get(PayuConstants.CATEGORY).toString());
                                break;
                        }

                    }
                    offerDetailsList.add(payuOffer);
                }
                payuResponse.setOfferDetailsList(offerDetailsList);
            }

            if (response.has(PayuConstants.MSG)) {
                postData.setResult(response.getString(PayuConstants.MSG));
            }
            if (response.has(PayuConstants.STATUS) && response.getInt(PayuConstants.STATUS) == 0) {
                postData.setCode(PayuErrors.INVALID_HASH);
                postData.setStatus(PayuConstants.ERROR);
            } else {
                postData.setCode(PayuErrors.NO_ERROR);
                postData.setStatus(PayuConstants.SUCCESS);
            }

            payuResponse.setResponseStatus(postData);

        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return payuResponse;
    }

    @Override
    protected void onPostExecute(PayuResponse payuResponse) {
        super.onPostExecute(payuResponse);
        mCheckOfferDetailsApiListener.onCheckOfferDetailsApiResponse(payuResponse);
    }
}
